% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnostic.R
\name{ggally_nostic_sigma}
\alias{ggally_nostic_sigma}
\title{\code{\link{ggnostic}} leave one out model sigma}
\usage{
ggally_nostic_sigma(
  data,
  mapping,
  ...,
  lineColor = brew_colors("grey"),
  linePosition = attr(data, "broom_glance")$sigma
)
}
\arguments{
\item{data, mapping, ..., lineColor}{parameters supplied to \code{\link{ggally_nostic_line}}}

\item{linePosition}{line that is drawn in the background of the plot. Defaults to the overall model's sigma value.}
}
\value{
\pkg{ggplot2} plot object
}
\description{
A function to display \code{stats::\link[stats]{influence}}'s sigma value.
}
\details{
As stated in \code{stats::\link[stats]{influence}} documentation:

sigma: a vector whose i-th element contains the estimate of the residual standard deviation obtained when the i-th case is dropped from the regression.  (The approximations needed for GLMs can result in this being 'NaN'.)

A line is added to display the overall model's sigma value. This gives a baseline for comparison
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

dt <- broomify(stats::lm(mpg ~ wt + qsec + am, data = mtcars))
p_(ggally_nostic_sigma(dt, ggplot2::aes(wt, .sigma)))
}
\seealso{
\code{stats::\link[stats]{influence}}
}
