\name{ghap.blockstats}
\alias{ghap.blockstats}

\title{
Block statistics
}
\description{
Generate block summary statistics from pre-computed haplotype statistics.
}
\usage{
ghap.blockstats(hapstats, ncores=1)
}

\arguments{
  \item{hapstats}{
   A data.frame containing haplotype statistics, as generated by the \code{\link{ghap.hapstats}} function.
  }
  \item{ncores}{
   A numeric value specifying the number of processors to be used in parallelization of independent Markov chains (default = 1).
  }
}

\value{
 A data frame with columns:
 \item{BLOCK}{
  Block alias.
 }
 \item{CHR}{
  Chromosome name.
 }
 \item{BP1}{
  Block start position.
 }
 \item{BP2}{
  Block end position.
 }
 \item{EXP.H}{
  Block expected heterozygosity.
 }
 \item{N.ALLELES}{
  Number of HapAlleles per block.
 }
 
}

\details{
 For each haplotype block, the function counts the number of unique haplotype alleles and computes the expected heterozygosity \eqn{ 1 - \sum {p_{i}}^2 }, where \eqn{p_{i}} is the frequency of HapAllele \emph{i}. Please notice that when haplotypes are prunned out by frequency the block statistics can retrieve high expected heterozygosity for blocks with small number of HapAlleles.
}

\author{
Yuri Tani Utsunomiya <ytutsunomiya@gmail.com>
}

\examples{

# #### DO NOT RUN IF NOT NECESSARY ###
# 
# # Copy the example data in the current working directory
# ghap.makefile()
# 
# # Load data
# phase <- ghap.loadphase("human.samples", "human.markers", "human.phase")
# 
# # Subset data - markers with maf > 0.05
# maf <- ghap.maf(phase, ncores = 2)
# markers <- phase$marker[maf > 0.05]
# phase <- ghap.subsetphase(phase, unique(phase$id), markers)
# 
# # Generate blocks of 5 markers sliding 5 markers at a time
# blocks.mkr <- ghap.blockgen(phase, windowsize = 5, slide = 5, unit = "marker")
#
# # Generate matrix of haplotype genotypes
# ghap.haplotyping(phase, blocks.mkr, batchsize = 100, ncores = 2, outfile = "human")
#
# # Load haplotype genotypes
# haplo <- ghap.loadhaplo("human.hapsamples", "human.hapalleles", "human.hapgenotypes")
#
# #Compute haplotype statistics
# hapstats <- ghap.hapstats(haplo, ncores = 2)
#
#
# ### RUN ###
#
# #Compute block statistics
# blockstats <- ghap.blockstats(hapstats, ncores = 2)

}

