\name{Reduced.Binary}
\alias{Reduced.Binary}
\title{Reduced MCMC by Fixing Part of the Parameters}
\description{
  This function generates a sample from the reduced Markov Chain Monte Carlo 
  simulation for computing the Bayes factor for model comparison. The sample 
  cannot be used for inferences about the parameters, but only used for the 
  Bayes factor calculation. The function is based on the reduced form of the 
  GLMM-AR(p) model. It is not necessary to check convergence on the sample.
  }
  
\usage{
Reduced.Binary(Y,X, W, S, unit.id, time.id, m=1000, burnin=500, mcmc.pos,
               beta0,B0, D0, d0, E0, e0, nlag,tracking,
               monitor=c("rho","q.rho", "beta", "bi", "ct", "D", "E", "ystar", "u"), 
               fixed="NULL")}

\arguments{
    \item{Y}{A vector of the dichotomous response variable taking values of 0 and 1.}

    \item{X}{A matrix of covariates with fixed effects at all levels.}

    \item{W}{A matrix of covariates with subject-varying effects.}

    \item{S}{A matrix of covariates with time-varying effects.}

    \item{unit.id}{A vector of subject index, i.e., the i's. Note: the number of
                observations of each unit should be larger than the lag order, nlag. Those
                units which have fewer than or equal to nlag observations should be taken
                out of the sample in order to use the function.}

    \item{time.id}{A vector of time index, i.e., the t's. Note: no missing observations
               in the middle of the sample time periods of a unit are allowed. In other words,
               unbalanced data structures are allowed, but no broken data structure.}

    \item{m}{The number of iterations after burn-in and to be returned. }

    \item{burnin}{The number of burn-in iterations for the sampler.}

    \item{mcmc.pos}{The MCMC output generated by the full MCMC by using the function 
                of \code{GLMMARp.Binary}.}

   \item{beta0}{The prior mean of \eqn{\beta}{beta}.  This should be a 
          vector with dimension equal to the number of fixed-effect parameters 
          in the reduced form. Since the dimension is difficult for the user to
          compute when the model contains multiple random coefficients and multiple 
          group-level predictors, the function will provide the correct dimension 
          in the error message if the dimension of beta0 is incorrectly specified, 
          and the user can respecify beta0 with this information and recall the 
          function.}
  
    \item{B0}{The prior covariance matrix of \eqn{\beta}{beta}.  This should be a 
          positive definite matrix with dimension equal to the number of betas in 
          the reduced form of GLMM-AR(p).}
  
    \item{d0, D0}{The degree of freedom and scale matrix of the Wishart prior
                  on \eqn{b_i} which are the subject-level residuals. D0 should 
                  not be too defuse, otherwise it may takes a long time for 
                  the chain to converge. Recommended values is a*I, where a is 
                  between 1.67 and 10. No default is provided.}

    \item{e0, E0}{The degree of freedom and scale matrix of the Wishart prior
                  on \eqn{c_t} which are the time-level residuals. E0 should 
                  not be too defuse, otherwise it may takes a long time for 
                  the chain to converge. Recommended values is a*I, where a is 
                  between 1.67 and 10. No default is provided. All the priors put into 
                  this function should be the same as those used in the full MCMC. }

    \item{nlag}{A scalar of the lag order p, which should be an integer equal to 
                or greater than 1. At this stage, the function does not support the 
                GLMM-AR(0) moel, which can be estimated by using BUGs or JAGs.}

    \item{tracking}{The tracking interval in the simulation. Every "tracking" 
              iterations, the function will return the information about how many 
              iterations in total have been done. The default is 0 and no tracking
              information will be given during the simulation.}

    \item{monitor}{A string contains the names of parameters whose MCMC output are
              to be returned. The string has to be a subset of
               ("rho", "beta", "bi", "ct", "D", "E", "ystar", "u") which is also the default.}
   
    \item{fixed}{A string specifying which parameters are fixed in the reduced simulation.}
   
}

\value{
   A list that contains the posterior sample. The same format as the sample 
   returned by GLMMARp.Binary().
}

\details{
\code{ReducedMCMC.Binary} is a funtion for conducting reduced runs for empirically integration in 
   the process of computing the Bayes factor. The partition of the parameters is set by the function, 
   and the user is not given the option of re-partitioning those parameters. 	
}
  
\references{
   Albert, James A. and Siddhartha Chib. 1993. "Bayesian Analysis of Binary and Polychotomous Response Data." \emph{Journal of the American Statistical Association.} 88: 669-679.

   Chib, Siddhartha. 1995. "Marginal Likelihood from the Gibbs Output." \emph{Journal of the American Statistical Association.} 90: 1313-1321. 

  Chib, Siddhartha, and Ivan Jeliazkov. 2001. "Marginal Likelihood from the Metropolis-Hastings Output." \emph{Journal of the American Statistical Association. } 96: 270-281.
}


\examples{
   \dontrun{

   }
}

\keyword{models}
