% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EMAlgortihm.R
\name{EMAlgorithm}
\alias{EMAlgorithm}
\title{EM algorithm for Gaussian mixture models}
\usage{
EMAlgorithm(x, theta, eps = 1e-06, max.ite = 1e+05, trace.theta = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{A matrix of observations where rows correspond to features and
columns to experiments.}

\item{theta}{A list of parameters as described in \code{\link{rtheta}}.}

\item{eps}{The maximal required difference in successive likelihoods to
establish convergence.}

\item{max.ite}{The maximum number of iterations.}

\item{trace.theta}{Logical. If \code{TRUE}, all estimates are stored and
returned. Default is \code{FALSE}.}

\item{verbose}{Set to \code{TRUE} for verbose output. Default is
\code{FALSE}.}
}
\value{
A list of length 3 with elements:
  \item{theta }{A list of the estimated parameters as described in
                \code{\link{rtheta}}.}
  \item{loglik.tr}{A numeric vector of the log-likelihood trace.}
  \item{kappa }{A matrix where \code{kappa[i,j]} is the probability that
                \code{x[i, ]} is realized from the \code{j}'th component.}
}
\description{
The regular expectation-maximization algorithm for general multivariate
Gaussian mixture models.
}
\details{
Though not as versatile, the algorithm can be a faster alternative to
\code{Mclust} in the \code{mclust}-package.
}
\examples{
set.seed(10)
data <- SimulateGMCMData(n = 1000, d = 2, m = 3)
start.theta <- rtheta(d = 2, m = 3)
res <- GMCM:::EMAlgorithm(data$z, theta = start.theta)

par(mfrow = c(1,2))
plot(data$z, cex = 0.5, pch = 16, main = "Simulated data",
     col = rainbow(3)[data$K])
plot(data$z, cex = 0.5, pch = 16, main = "GMM clustering",
     col = rainbow(3)[apply(res$kappa,1,which.max)])
}
\author{
Anders Ellern Bilgrau (abilgrau@math.aau.dk)
}
\seealso{
\code{\link{rtheta}}, \code{\link{PseudoEMAlgorithm}}
}

