% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ng.post.df.r
\name{get.ng.post.df}
\alias{get.ng.post.df}
\title{Normal-Gamma Posterior Updating data.frame}
\usage{
get.ng.post.df(
  mu.0 = 0,
  n.0 = 10,
  alpha.0 = 0.25,
  beta.0 = 1,
  xbar = 0.25,
  s = c(1, 2, 3),
  n = 15,
  group = "Control"
)
}
\arguments{
\item{mu.0}{prior mean}

\item{n.0}{prior effective sample size}

\item{alpha.0}{prior alpha parameter}

\item{beta.0}{prior beta parameter}

\item{xbar}{observed sampled mean}

\item{s}{observed sample standard deviation}

\item{n}{sample size}

\item{group}{text string for group label}
}
\value{
Returns a data.frame with prior, data, and posterior parameters.
}
\description{
Normal-Gamma Posterior Updating data.frame
}
\examples{
my.ng.post.df <- get.ng.post.df(mu.0 = 0, n.0 = 10, alpha.0 = .25, beta.0 = 1,
xbar = .25, s = c(1,2,3), n = 15, group = "Control")
my.ng.post.df
}
