% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.bin.int.oc.r
\name{get.ss.bin.int.oc}
\alias{get.ss.bin.int.oc}
\title{Get single sample binary interim operating characteristics simulation}
\usage{
get.ss.bin.int.oc(
  ss.bin.int.df,
  ss.bin.int.GNG,
  lower = 0,
  upper = 1,
  step = 0.025,
  include_nogo = TRUE
)
}
\arguments{
\item{ss.bin.int.df}{call to get.ss.bin.interim.df}

\item{ss.bin.int.GNG}{call to get.ss.bin.interim.GNG}

\item{lower}{lower bound}

\item{upper}{upper bound}

\item{step}{stepsize}

\item{include_nogo}{logical}
}
\value{
Returns a data.frame holding results at interim and final
}
\description{
Get single sample binary interim operating characteristics simulation
}
\examples{
\donttest{
my.ss.bin.int.df = get.ss.bin.int.df(ss.bin.studyend.GNG =
get.ss.bin.studyend.GNG(a.trt = 1, b.trt = 1, n.trt = 40, x.trt = 9,
Delta.lrv = .2, Delta.tv = .35,
tau.tv = 0.10, tau.lrv = .80, tau.ng = .65),
goThreshold = .8,
nogoThreshold = 1.2,
include_nogo = TRUE)
my.ss.bin.studyend.GNG <- get.ss.bin.studyend.GNG(a.trt = 1, b.trt = 1, n.trt = 40, x.trt = 9,
                                                  Delta.lrv = .2, Delta.tv = .35,
     tau.tv = 0.10, tau.lrv = .80, tau.ng = .65)
my.ss.bin.int.GNG <- get.ss.bin.int.GNG( ss.bin.int.df = my.ss.bin.int.df,
                                        Interims = 20,
ss.bin.studyend.GNG = my.ss.bin.studyend.GNG)
my.ss.bin.int.GNG
}

}
