% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ts.ng.ppp.r
\name{make.ts.ng.ppp}
\alias{make.ts.ng.ppp}
\title{Make two-sample normal-gamma prior/posterior plot}
\usage{
make.ts.ng.ppp(
  mu.0.c = 0,
  alpha.0.c = 2.5,
  beta.0.c = 10,
  n.0.c = 10,
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 1e-04,
  xbar.c = 0.25,
  s.c = 1.5,
  n.c = 55,
  xbar.t = 2.5,
  s.t = 1.5,
  n.t = 55,
  limits = c(5, 25, 10)
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{n.0.c}{prior effective sample size parameter for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{n.0.t}{prior effective sample size parameter for treatment group}

\item{xbar.c}{control mean}

\item{s.c}{control sd}

\item{n.c}{control sample size}

\item{xbar.t}{treatment mean}

\item{s.t}{treatment sd}

\item{n.t}{treatment sample size}

\item{limits}{limits for visualizing precision, variance, standard deviation}
}
\value{
a ggplot object is returned
}
\description{
Make two-sample normal-gamma prior/posterior plot
}
\examples{
my.ts.ng.ppp <- make.ts.ng.ppp()
my.ts.ng.ppp[[1]][[1]]
my.ts.ng.ppp[[1]][[2]]
my.ts.ng.ppp[[1]][[3]]
my.ts.ng.ppp[[1]][[4]]
gridExtra::grid.arrange(my.ts.ng.ppp[[1]][[1]], my.ts.ng.ppp[[1]][[3]],
my.ts.ng.ppp[[1]][[2]], my.ts.ng.ppp[[1]][[4]])
my.ts.ng.ppp[[2]]
my.ts.ng.ppp[[3]]
my.ts.ng.ppp[[4]]
my.ts.ng.ppp[[5]]
my.ts.ng.ppp[[6]]
my.ts.ng.ppp[[7]]
}
