% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.tte.ria.r
\name{make.tte.ria}
\alias{make.tte.ria}
\title{Make time to event rule in action plot}
\usage{
make.tte.ria(
  m.con.prior = 1,
  m.trt.prior = 1,
  HR.prior = 1,
  ARatio = 0.5,
  HR.obs = 0.845,
  m.obs = 1500,
  HR.tv = 0.8,
  HR.lrv = 0.9,
  tau.tv = 0.1,
  tau.lrv = 0.7,
  tau.ng = 0.7,
  tsize = 4,
  nlines = 25,
  nlines.ria = 20,
  add.table = TRUE
)
}
\arguments{
\item{m.con.prior}{prior number of control events}

\item{m.trt.prior}{prior number of treatment events}

\item{HR.prior}{prior estimate for HR}

\item{ARatio}{Allocation ratio}

\item{HR.obs}{observed hazard ratio}

\item{m.obs}{observed number of events}

\item{HR.tv}{TPP Target Value aka Base TPP}

\item{HR.lrv}{TPP Lower Reference Value aka Max TPP (large HRs lead to No-Go)}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{tsize}{Control for text size}

\item{nlines}{Control for text spacing}

\item{nlines.ria}{Control for text spacing}

\item{add.table}{provides extended output summaries}
}
\value{
A ggplot object is returned.
}
\description{
Make time to event rule in action plot
}
\examples{
my.tte.ria <- make.tte.ria(add.table=TRUE)
plot(my.tte.ria[[1]])
my.tte.ria[[2]]
my.tte.ria[[3]]
my.tte.ria[[4]]
}
