% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ts.bin.int.predprob.r
\name{return.ts.bin.int.predprob}
\alias{return.ts.bin.int.predprob}
\title{Return two-sample binary interim predictive probability}
\usage{
return.ts.bin.int.predprob(
  a.con = 1,
  b.con = 1,
  a.trt = 1,
  b.trt = 1,
  Delta.lrv = 0.3,
  Delta.tv = 0.4,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.8,
  n.int.con = 20,
  n.int.trt = 20,
  x.int.con = 17,
  x.int.trt = 17,
  n.final.trt = 40,
  n.final.con = 40
)
}
\arguments{
\item{a.con}{alpha parameter for control}

\item{b.con}{beta parameter for control}

\item{a.trt}{alpha parameter for trt}

\item{b.trt}{beta parameter for trt}

\item{Delta.lrv}{TPP info}

\item{Delta.tv}{TPP info}

\item{tau.tv}{Threshold}

\item{tau.lrv}{Threshold}

\item{tau.ng}{Threshold}

\item{n.int.con}{Sample size, control group at interim}

\item{n.int.trt}{Sample size, treatment group at interim}

\item{x.int.con}{Responders, control group at interim}

\item{x.int.trt}{Responders, treatment group at interim}

\item{n.final.trt}{Final sample size treatment}

\item{n.final.con}{Final sample size control}
}
\value{
A data.frame is returned
}
\description{
Return two-sample binary interim predictive probability
}
\examples{
\donttest{
return.ts.bin.int.predprob()
}
}
