% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrs_get_counties.R
\name{GNRS_get_counties}
\alias{GNRS_get_counties}
\title{Get metadata on counties}
\usage{
GNRS_get_counties(state_province_id = "")
}
\arguments{
\item{state_province_id}{A GNRS state_id, or a vector of state_ids.}
}
\value{
Dataframe containing information on counties/parishes (e.g. iso code, fips code, continent, standardized name)
}
\description{
Return metadata about counties, parishes, etc. used by the GNRS
}
\examples{
\dontrun{
states <- GNRS_get_states()
us_counties <- GNRS_get_counties(
state_province_id = states$state_province_id[
which(states$country_iso == "US")])
}

}
