% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_deriv_weights_gp.R
\name{compute_deriv_weights_gp}
\alias{compute_deriv_weights_gp}
\title{Calculate Derivatives of CERF}
\usage{
compute_deriv_weights_gp(
  w,
  w_obs,
  GPS_m,
  hyperparam,
  kernel_fn = function(x) exp(-x),
  kernel_deriv_fn = function(x) -exp(-x)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{GPS_m}{A data.table of GPS vectors. Including:
\itemize{
\item Column 1: GPS values.
\item Column 2: Prediction of exposure for covariate of each data
sample (e_gps_pred).
\item Column 3: Standard deviation of  e_gps (e_gps_std)
}}

\item{hyperparam}{A vector of hyper-parameters in the GP model.}

\item{kernel_fn}{The covariance function.}

\item{kernel_deriv_fn}{The partial derivative of the covariance function.}
}
\value{
A vector of weights for all samples, based on which the posterior mean of
the derivative of CERF at the exposure level of interest is calculated.
}
\description{
Calculates the weights assigned to each observed outcome when deriving the
posterior mean of the first derivative of CERF at a given exposure level.
}
\examples{

set.seed(915)
data <- generate_synthetic_data(sample_size = 150)
GPS_m <- train_GPS(cov_mt = as.matrix(data[,-(1:2)]),
                   w_all = as.matrix(data$treat))

wi <- 4.8
weights <- compute_deriv_weights_gp(w = wi,
                                    w_obs = data$treat,
                                    GPS_m = GPS_m,
                                    hyperparam = c(1,1,2))

}
