% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFouriertest.R
\name{GPPFouriertest}
\alias{GPPFouriertest}
\title{GPPFourier test function}
\usage{
GPPFouriertest(x, dt = NULL, units = "days", Detrend = FALSE,
  filter = FALSE, Nfilt = NULL, circular = FALSE, sides = 2,
  filtcorrect = TRUE, trunclight = TRUE, fDL = NULL, usefft = FALSE,
  padlength = 0, fourierderive = FALSE, confine = "days", taper = FALSE,
  p = 0.1)
}
\arguments{
\item{x}{O2 time series from which GPP is to be calculated}

\item{dt}{Sample time step}

\item{units}{Time unit of sampling time step}

\item{Detrend}{Toggle time series detrending. See GPPFourierPreprocess}

\item{filter}{Toggle time series filtering. See GPPFourierPreprocess}

\item{Nfilt}{Moving average filter width}

\item{circular}{Moving average circular boundary condition
(see documentation of filter())}

\item{sides}{Moving average central or one sided (see documentation of
filter())}

\item{filtcorrect}{Logical controlling whether GPP estimate
is corrected for signal falsely removed by filtering}

\item{trunclight}{Use truncated sinusoid approximation for light&GPP. If
FALSE, a sinusoid approximation is assumed}

\item{fDL}{Relative fraction of light hours during the day}

\item{usefft}{If FALSE the amplitude at diel freqyency is computed directly. If TRUE fft() is used to estimate amplitude at diel frequency.}

\item{padlength}{Number of zeroes to be appended to the time series to
increase frequency resolution}

\item{fourierderive}{Calculate derivative in the frequency domain or not}

\item{confine}{Confine time series to integer number of days or tidal cycles}

\item{taper}{Taper the time series with spec.taper()}

\item{p}{Fraction of the time series to be tapered at each side}
}
\description{
GPPFourier test function
}
\details{
This function allows to play around with the basics behind GPPFourier and
GPPFourierPreprocess

\code{trunclight} controls whether GPP is assumed to evolving as a truncated
sinusoid over a day or as a pure sinusoidal.  This assumption determines the
relation between time averaged GPP and the Fourier amplitude at diel
frequency

\code{usefft}: by default \code{GPPFourier()} calculates the amplitude at
diel frequency directly \code{fft()} calculates the full Fourier transform
of the time series. The amplitude at diel frequency can be derived from the
Fourier transform

\code{fourierderive}: if TRUE time derivation is performed in the Fourier
domain by multiplying with i x omega, omega being the diurnal angular
frequency.  Thus the GPPFouriertest returns the amplitude at diel frequency of dx/dt. If
fourierderive is FALSE, the amplitude at diel frequency of x is returned
(multiplied with the factor determined by \code{trunclight}
}
\references{
Cox T.J.S. et al. (2015) 'Estimating primary production from oxygen time series: a novel approach in the frequency domain', Limnology And Oceanography:Methods 13, 529-552. DOI: 10.1002/lom3.10046
}
\seealso{
\link{GPPFourier}, \link{GPPFourierPreprocess}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
