% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metropolis_sampler.R
\name{metropolis_sampler}
\alias{metropolis_sampler}
\title{Metropolis sampler for a target density}
\usage{
metropolis_sampler(
  initial_value,
  n = n,
  proposal_shape = 1,
  proposal_scale = 1,
  theta = 1,
  proportion = 0.5,
  mu = 1,
  kappas = 0.9,
  burnin = 0,
  lag = 1
)
}
\arguments{
\item{initial_value}{initial values}

\item{n}{number of draws}

\item{proposal_shape}{Weibull's shape parameter in the proposal}

\item{proposal_scale}{Weibull's scale parameter in the proposal}

\item{theta}{cure rate parameter (log scale)}

\item{proportion}{proportions data}

\item{mu}{mean survival time}

\item{kappas}{Weibull's true shape parameter}

\item{burnin}{length of burn-in period}

\item{lag}{discarding lag-1 values in the Metropolis step}
}
\value{
A dataframe consisting of the sampled values and acceptance rate
}
\description{
Random number generator via Metropolis-Hastings algorithm.
}
\examples{

times <- metropolis_sampler(10, 5)

}
