% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPNode.R
\name{GPNode}
\alias{GPNode}
\title{R6 Class for the nodes / leaves in the GPTree tree}
\description{
The nodes contain the local GP if they are leaves (at the end of a branch). Nodes that are just nodes contain information on how the input space was split. They are responsible for computing and updating the splitting probabilities. Also, the tree interacts with the local GPs through the nodes.

Currently, GPs from the \code{DiceKriging} package (\link{WrappedDiceKrigingGP}) and \code{mlegp} package (\link{WrappedmlegpGP}) are implemented. The user can create their own wrapper using \link{WrappedGP}.
}
\seealso{
\code{\link[=GPTree]{GPTree()}} for the main methods
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{key}}{A string like "0110100" to identify the node in the binary tree}

\item{\code{x_dim}}{Dimensionality of input points. It is set once the first point is received through the \link{GPTree} method \code{update}. It needs to be specified if \code{min_ranges} should be different from default.}

\item{\code{theta}}{Overlap ratio between two leafs in the split direction. The default value is 0.}

\item{\code{split_direction_criterion}}{A string that indicates which spitting criterion to use. The options are:
\itemize{
\item \code{"max_spread"}: Split along the direction which has the largest data spread.
\item \code{"min_lengthscale"}: split along the direction with the smallest length-scale hyperparameter from the local GP.
\item \code{"max_spread_per_lengthscale"}: Split along the direction with the largest data spread relative to the corresponding GP length-scale hyperparameter.
\item \code{"max_corr"}: Split along the direction where the input data is most strongly correlated with the target variable.
\item \code{"principal_component"}: Split along the first principal component.
}

The default value is \code{"max_spread_per_lengthscale"}.}

\item{\code{split_position_criterion}}{A string indicating how the split position along the split direction should be set. Possible values are (\code{"mean"} and \code{"median"}). The default is \code{"mean"}.}

\item{\code{shape_decay}}{A string specifying how the probability function for a point to be assigned to the left leaf should fall off in the overlap region. The available options are a linear shape (\code{"linear"}), an exponential shape (\code{"exponential"}) or a Gaussian shape (\code{"gaussian"}). Another option is to select no overlap region. This can be achieved by selecting \code{"deterministic"} or to set \code{theta} to 0. The default is \code{"linear"}.}

\item{\code{prob_min_theta}}{Minimum probability after which the overlap shape gets truncated (either towards 0 or 1). The default value is 0.01.}

\item{\code{Nbar}}{Maximum number of data points for each GP in a leaf before it is split. The default value is 1000.}

\item{\code{min_ranges}}{Smallest allowed input data spread (per dimension) before node splitting stops. It is set to its default \code{min_ranges = rep(0.0, x_dim)} once the first point is received through the \code{update} method. \code{x_dim} needs to be specified by the user if it should be different from the default.}

\item{\code{is_leaf}}{If TRUE, this node a leaf, i.e the last node on its branch}

\item{\code{wrapped_gp}}{An instance of the WrappedGP type}

\item{\code{can_split}}{If TRUE for a given dimension, the leaf can be split along that dimension}

\item{\code{rotation_matrix}}{A rotation matrix, used for transforming the data}

\item{\code{shift}}{A shift, used for transforming the data}

\item{\code{use_pc_transform}}{TRUE if principal components transformation is used for node splitting}

\item{\code{x_spread}}{Vector of data spread for each dimension}

\item{\code{split_index}}{Index for the split dimension}

\item{\code{position_split}}{Position of the split along dimension split_index}

\item{\code{width_overlap}}{Width of overlap region along dimension split_index}

\item{\code{point_ids}}{IDs of the points assigned to this node}

\item{\code{residuals}}{Vector of residuals}

\item{\code{pred_errs}}{Vector of prediction uncertainties}

\item{\code{error_scaler}}{Scaling factor for the prediction error to ensure desired coverage}

\item{\code{use_n_residuals}}{Number of past residuals to use in calibrating the \code{error_scaler}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GPNode-new}{\code{GPNode$new()}}
\item \href{#method-GPNode-transform}{\code{GPNode$transform()}}
\item \href{#method-GPNode-update_prob_pars}{\code{GPNode$update_prob_pars()}}
\item \href{#method-GPNode-get_prob_child_1}{\code{GPNode$get_prob_child_1()}}
\item \href{#method-GPNode-register_residual}{\code{GPNode$register_residual()}}
\item \href{#method-GPNode-update_empirical_error_pars}{\code{GPNode$update_empirical_error_pars()}}
\item \href{#method-GPNode-delete_gp}{\code{GPNode$delete_gp()}}
\item \href{#method-GPNode-clone}{\code{GPNode$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-new"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-new}{}}}
\subsection{Method \code{new()}}{
Create a new node object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$new(
  key,
  x_dim,
  theta,
  split_direction_criterion,
  split_position_criterion,
  shape_decay,
  prob_min_theta,
  Nbar,
  wrapper,
  gp_control,
  retrain_buffer_length,
  add_buffer_in_prediction,
  min_ranges = NULL,
  is_leaf = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A string like "0110100" to identify the node in the binary tree}

\item{\code{x_dim}}{Dimensionality of input points. It is set once the first point is received through the \link{GPTree} method \code{update}. It needs to be specified if \code{min_ranges} should be different from default.}

\item{\code{theta}}{Overlap ratio between two leafs in the split direction. The default value is 0.}

\item{\code{split_direction_criterion}}{A string that indicates which spitting criterion to use. The options are:
\itemize{
\item \code{"max_spread"}: Split along the direction which has the largest data spread.
\item \code{"min_lengthscale"}: split along the direction with the smallest length-scale hyperparameter from the local GP.
\item \code{"max_spread_per_lengthscale"}: Split along the direction with the largest data spread relative to the corresponding GP length-scale hyperparameter.
\item \code{"max_corr"}: Split along the direction where the input data is most strongly correlated with the target variable.
\item \code{"principal_component"}: Split along the first principal component.
}

The default value is \code{"max_spread_per_lengthscale"}.}

\item{\code{split_position_criterion}}{A string indicating how the split position along the split direction should be set. Possible values are (\code{"mean"} and \code{"median"}). The default is \code{"mean"}.}

\item{\code{shape_decay}}{A string specifying how the probability function for a point to be assigned to the left leaf should fall off in the overlap region. The available options are a linear shape (\code{"linear"}), an exponential shape (\code{"exponential"}) or a Gaussian shape (\code{"gaussian"}). Another option is to select no overlap region. This can be achieved by selecting \code{"deterministic"} or to set \code{theta} to 0. The default is \code{"linear"}.}

\item{\code{prob_min_theta}}{Minimum probability after which the overlap shape gets truncated (either towards 0 or 1). The default value is 0.01.}

\item{\code{Nbar}}{Maximum number of data points for each GP in a leaf before it is split. The default value is 1000.}

\item{\code{wrapper}}{A string that indicates which GP implementation should be used. The current version includes wrappers for the packages \code{"DiceKriging"} and \code{"mlegp"}. The default setting is \code{"DiceKriging"}.}

\item{\code{gp_control}}{A \code{list} of control parameter that is forwarded to the wrapper. Here, the covariance function is specified. \code{DiceKriging} allows for the following kernels, passed as string: \code{"gauss"}, \code{"matern5_2"}, \code{"matern3_2"}, \code{"exp"}, \code{"powexp"} where \code{"matern3_2"} is set as default.}

\item{\code{retrain_buffer_length}}{Size of the retrain buffer. The buffer for a each node collects data points and holds them until the buffer length is reached. Then the GP in the node is updated with the data in the buffer. For a fixed \code{Nbar}, higher values for \code{retrain_buffer_length} lead to faster run time (less frequent retraining), but the trade-off is a temporary reduced prediction accuracy. We advise that the choice for \code{retrain_buffer_length} should depend on the chosen \code{Nbar}. By default \code{retrain_buffer_length} is set equal to \code{Nbar}.}

\item{\code{add_buffer_in_prediction}}{If TRUE, points in the data buffers are added to the GP before prediction. They are added into a temporarily created GP which contains the not yet included points. The GP in the node is not yet updated. The default is \code{FALSE}.}

\item{\code{min_ranges}}{Smallest allowed input data spread (per dimension) before node splitting stops. It is set to its default \code{min_ranges = rep(0.0, x_dim)} once the first point is received through the \link{GPTree} method \code{update}. \code{x_dim} needs to be specified by the user if it should be different from the default.}

\item{\code{is_leaf}}{If TRUE, this node a leaf, i.e the last node on its branch.}

\item{\code{n_points_train_limit}}{Number of points at which a GP is created in the leaf}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new GPNode object. Contains the local GP in the field \code{wrapped_gp}, and information used for and related to splitting the node. If the node has been split, the local GP is removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-transform"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-transform}{}}}
\subsection{Method \code{transform()}}{
Method to transform input data through a shift and a rotation. IS EXPECTED TO NOT BE CALLED BY THE USER
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Matrix with x points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transformed X matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-update_prob_pars"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-update_prob_pars}{}}}
\subsection{Method \code{update_prob_pars()}}{
Method to update the probability parameters (x_spread, can_split, split_index, position_split, width_overlap). IS EXPECTED TO NOT BE CALLED BY THE USER
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$update_prob_pars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-get_prob_child_1"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-get_prob_child_1}{}}}
\subsection{Method \code{get_prob_child_1()}}{
Method to compute the probability that a point x should go to child 1. IS EXPECTED TO NOT BE CALLED BY THE USER
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$get_prob_child_1(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Single data point for which probability is computed; has to be a vector with length equal to x_dim}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The probability that a point x should go to child 1
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-register_residual"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-register_residual}{}}}
\subsection{Method \code{register_residual()}}{
Method to register prediction performance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$register_residual(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Most recent single input data point from the data stream; has to be a vector with length equal to x_dim}

\item{\code{y}}{Target variable which has to be a one-dimensional matrix or a vector; any further columns will be ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-update_empirical_error_pars"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-update_empirical_error_pars}{}}}
\subsection{Method \code{update_empirical_error_pars()}}{
Method for updating the empirical error parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$update_empirical_error_pars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-delete_gp"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-delete_gp}{}}}
\subsection{Method \code{delete_gp()}}{
Method to delete the GP. IS EXPECTED TO NOT BE CALLED BY THE USER
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$delete_gp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GPNode-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GPNode-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GPNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
