% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{fastfun-class}
\alias{fastfun-class}
\alias{predict,fastfun-method}
\alias{update,fastfun-method}
\title{Class for fast to compute objective.}
\usage{
\S4method{predict}{fastfun}(object, newdata, ...)

\S4method{update}{fastfun}(object, newX, newy, ...)
}
\arguments{
\item{object}{\code{\link[GPareto]{fastfun}} object}

\item{newdata}{Matrix of the new location for the design}

\item{...}{further arguments (not used)}

\item{newX}{Matrix of the new location for the design}

\item{newy}{Matrix of the responses at \code{newX}}
}
\description{
Class for fast to compute objective.
}
\section{Methods (by generic)}{
\itemize{
\item \code{predict}: Predict(by evaluating \code{fun}) the result at a new observation.

\item \code{update}: Update the \code{X} and \code{y} slots with a new design and observation.
}}
\section{Slots}{

\describe{
\item{\code{d}}{spatial dimension,}

\item{\code{n}}{observations number,}

\item{\code{X}}{the design of experiments, size \code{n x d},}

\item{\code{y}}{the observations, size \code{n x 1},}

\item{\code{fun}}{the evaluator function.}
}}
\section{Objects from the Class }{
 To create a \code{fastfun} object, use \code{\link[GPareto]{fastfun}}. See also this function for more details.
}
\keyword{internal}

