% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSymDifRNP.R
\name{plotSymDifRNP}
\alias{plotSymDifRNP}
\title{Symmetrical difference of RNP sets}
\usage{
plotSymDifRNP(set1, set2, xlim, ylim, fill = "black", add = "FALSE", ...)
}
\arguments{
\item{set1, set2}{RNP sets considered,}

\item{xlim, ylim}{numeric vectors of length 2, giving the \code{x} and \code{y} coordinates ranges for plotting,}

\item{fill}{optional color of the symmetric difference area,}

\item{add}{logical; if \code{TRUE} add to an already existing plot; if \code{FALSE} (default) start a new plot taking \code{xlim, ylim} as limits.}

\item{...}{additional parameters for the \code{\link[graphics]{plot}} and \code{\link[graphics]{polygon}} graphic functions}
}
\description{
Plot the symmetrical difference between two 
Random Non-Dominated Point (RNP) sets.
}
\examples{
#------------------------------------------------------------
# Simple example
#------------------------------------------------------------
set1 <- rbind(c(0.2, 0.35, 0.5, 0.8),
              c(0.8, 0.6, 0.55, 0.3))

set2 <- rbind(c(0.3, 0.4),
              c(0.7, 0.4))

plotSymDifRNP(set1, set2, xlim = c(0, 1), ylim = c(0, 1), fill = "grey")
points(t(set1), col = "red", pch = 20)
points(t(set2), col = "blue", pch = 20)
}
