% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p2dMax.R
\name{p2dMax}
\alias{p2dMax}
\title{p2dMax : provides dMax given pMax and nVar}
\usage{
p2dMax(nVar, pMaxKnown)
}
\arguments{
\item{nVar}{The model dimension expected. This parameter will be
deduced from the input data (\code{series}) if \code{series} is
a matrix. If \code{series} is a vector, the expected dimension nVar
should be provided.}

\item{pMaxKnown}{The number of polynoms terms to retrieve}
}
\value{
The maximum polynomial degree \code{dMax} used to code the polynomial
}
\description{
Search the maximum polynomial degree dMax
             given the number of polynomial terms pMax
             and the system dimension nVar
}
\examples{
#############
# Example 1 #
#############
# Maximum polynomial degree ?
# number of variables:
nVar <- 3
# size of the polynomial vector:
pMax <- 10
# The maximal polynomial degree used for coding the polynomial is:
p2dMax(nVar,pMax)

#############
# Example 2 #
#############
# for pMax = 462 and nVar = 6, then dMax is:
p2dMax(6,462)
# indeed:
length(poLabs(nVar=6, dMax=5))

}
\author{
Sylvain Mangiarotti, Laurent Drapeau
}
\seealso{
\code{\link{gloMoId}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}

