% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ross76-data.R
\docType{data}
\encoding{UTF-8}
\name{Rossler-1976 data set}
\alias{Rossler-1976 data set}
\alias{Ross76}
\title{Time series of the Rossler-1976 system}
\format{An object of class \code{deSolve} (inherits from \code{matrix}) with 4000 rows and 4 columns.}
\usage{
Ross76
}
\description{
The Rössler system is the 3-dimensional chaotic system \cr
\eqn{dx/dt = - y - z} \cr
\eqn{dy/dt = x + a y} \cr
\eqn{dz/dt = b + z (x - c)}, \cr
discovered by Otto E. Rössler in 1976 [1].
The following parameters and initial conditions
were used to produce the present data set:\cr
a = 0.520, b = 2, c = 4 \cr
and (x0, y0, z0) = (-0.04298734, 1.025536, 0.09057987).\cr
The following four columns are provided:\cr
(1) time t, (2) x(t), (3) y(t) and (4) z(t).\cr
For this parameterization, the Rössler system produces
a chaotic behavior characterized by a regime
non-coherent in phase (oscillations duration can be
very different from one oscillation to another).
}
\references{
[1] O. Rössler, 1976. An Equation for Continuous Chaos,
Physics Letters, 71A, 2-3, 155-157. \cr
}
\author{
Sylvain Mangiarotti, Flavie Le Jean,
Malika Chassan, Laurent Drapeau, Mireille Huc.
}
\keyword{data}
