% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.SimuGMatFromGenoFile}
\alias{GRAB.SimuGMatFromGenoFile}
\title{GRAB: simulate genotype matrix based on family structure}
\usage{
GRAB.SimuGMatFromGenoFile(
  nFam,
  nSub,
  FamMode,
  GenoFile,
  GenoFileIndex = NULL,
  SampleIDs = NULL,
  control = NULL
)
}
\arguments{
\item{nFam}{number of families in simulation}

\item{nSub}{number of unrelated subjects in simulation}

\item{FamMode}{"4-members", "10-members", or "20-members". Check Details section for more details.}

\item{GenoFile}{this parameter is passed to \code{GRAB.ReadGeno} to read in genotype data.}

\item{GenoFileIndex}{this parameter is passed to \code{GRAB.ReadGeno} to read in genotype data.}

\item{SampleIDs}{this parameter is passed to \code{GRAB.ReadGeno} to read in genotype data.}

\item{control}{this parameter is passed to \code{GRAB.ReadGeno} to read in genotype data.}
}
\value{
a genotype matrix of genotype data
}
\description{
Simulate genotype matrix based on family structure using haplotype information from genotype files. This function is mainly to simulate genotype data for rare variants analysis. NOTE: if simulating related subjects, the genotype of two allele will be assigned to two haplotypes of one allele randomly.
}
\details{
Currently, function \code{GRAB.SimuGMatFromGenoFile} supports both unrelated and related subjects.
Genotype data of founders is from \code{GenoFile} and \code{GenoFileIndex}.
\subsection{If \code{FamMode = "4-members"}}{

Total number of subjects is \code{nSub + 4 * nFam}. Each family includes 4 members with the family structure as below: 1+2->3+4.
}

\subsection{If \code{FamMode = "10-members"}}{

Total number of subjects is \code{nSub + 10 * nFam}. Each family includes 10 members with the family structure as below: 1+2->5+6, 3+5->7+8, 4+6->9+10.
}

\subsection{If \code{FamMode = "20-members"}}{

Total number of subjects is \code{nSub + 20 * nFam}. Each family includes 20 members with the family structure as below: 1+2->9+10, 3+9->11+12, 4+10->13+14, 5+11->15+16, 6+12->17, 7+13->18, 8+14->19+20.
}
}
\examples{
nFam <- 50
nSub <- 500
FamMode <- "10-members"

# PLINK data format. Currently, this function does not support BGEN data format.
PLINKFile <- system.file("extdata", "example_n1000_m236.bed", package = "GRAB")
IDsToIncludeFile <- system.file("extdata", "example_n1000_m236.IDsToInclude", package = "GRAB")

GenoList <- GRAB.SimuGMatFromGenoFile(nFam, nSub, FamMode, PLINKFile,
  control = list(IDsToIncludeFile = IDsToIncludeFile)
)

}
