% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour_color_grid.R
\name{contour_color_grid}
\alias{contour_color_grid}
\title{Draws the density / distribution function of a grid copula with contours and colors}
\usage{
contour_color_grid(
  gc,
  FUN = "d.grid",
  u1 = seq(0, 1, length.out = 21),
  u2 = seq(0, 1, length.out = 21),
  color.name = "heat.colors",
  color.size = 7
)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{FUN}{the name of the function to be applied (d.grid, p.grid), default is 'd.grid'.}

\item{u1}{indicates the place for lines on axis u1.}

\item{u2}{indicates the place for lines on axis u2.}

\item{color.name}{indicates the palette of colors.}

\item{color.size}{indicates the number of colors.}
}
\value{
Returns a graph of the density / distribution.
}
\description{
Draws the density / distribution function of a grid copula with contours and colors
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
contour_color_grid(gc = copula.grid, FUN = 'd.grid', color.name = "rainbow") 
contour_color_grid(gc = copula.grid, FUN = 'p.grid', color.name = "rainbow") 
}
