% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_grid.R
\name{d.grid}
\alias{d.grid}
\title{Evaluates the density of a grid type copula}
\usage{
d.grid(U, V = NULL, gc)
}
\arguments{
\item{U}{a matrix of size nx2 with the observed values. It can also be a vector of size kx1 with the values of the U1 variable.}

\item{V}{optional, a vector of size kx1 with the values of the U2 variable.}

\item{gc}{a grid type copula object.}
}
\value{
Returns a vector with the corresponding density.
}
\description{
Returns the corresponding density values of a grid type copula.
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 5
m <- 4
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
d.grid(df,gc=copula.grid)
}
