\name{GWG-package}
\alias{GWG-package}
\alias{GWG}
\docType{package}
\title{Calculation of probabilities for inadequate or excessive gestational weight gain. 
}
\description{The package calculates probabilities for inadequate or excessive gestational weight gain (GWG) for different prevalences for different BMI categories. The sensitivities and specificities that are required to calculate the probabilities for inadequate or excessive GWG are based on a dataset of 758 women from two merged German cohorts (LMU cohort: delivered in the Departement of Obsterics and Gynecology of the University of Munich, LMU  from Dezember 2010 to October 2011 and November 2011 to September 2012; PEACHES cohort (Programming of Enhanced Adiposity Risk in CHildhood - Early Screening (ongoing cohort study)): delivered in maternity clinics near to Munich, Germany, with inclusion criteria among other things: pre-gestational body mass index >=30 kg/m2). The total gestational weight gain was defined as difference between maternal pre-pregnancy weight and last weight measurement before delivery if performed in the 37th week or later. According to the IOM/NRC guidelines adequate total GWG was classified as total weight gain of 11.5-16 kg for normal weight women, 7-11.5 kg for overweight women and 5-9 kg for obese women. In accordance with IOM inadequate GWG was defined as GWG below and excessive GWG as values above the recommended GWG. Cut-off points for inadequate and excessive GWG were calculated for each week according to the IOM/NRC guidelines, whereby during pregnancy a linear progression of GWG is assumed with different slopes in the first trimester (week 1-13) and the following two trimesters (week 14-40). We divided pregnancy in four-week intervals according to the recommended intervals due to German guidelines for pregnancy visits. For example, interval ten includes the time period from 36 completed gestational weeks and 1 day (36/1 weeks) to 40 completed gestational weeks and 0 days (40/0 weeks). We calculated prognostic values for inadequate and excessive GWG for each month starting with the 2nd month (week 4/1-8/0) because of too little observations in the 1st. Categories of body mass index (BMI), calculated by dividing weight in kilograms by squared height in meters, were defined according to the IOM/NRCand WHO criterion (underweight: <18.5 kg/m^{2}, normal weight: 18.5 - 24.9 kg/m^{2}, overweight: 25-29.9 kg/m^{2}, obese: >= 30 kg/m^{2}). We excluded underweight women, because of negligible small prevalence. In the study, 367 of the women included were normal weight, 204 overweight and 186 were obese.}
\details{
Package: GWG

Type: Package

Version: 1.0

Date: 2013-01-16

License:  GPL (>= 2)

LazyLoad:  yes
}

\author{
Christina Riedel

Maintainer: Christina Riedel <christina.riedel@med.uni-muenchen.de>
}
\references{
Knabl J, Riedel C, Gmach J et al. (2013). Prediction of excessive or inadequate gestational weight gain from week-specific IOM/NRC cut-off values. submitted.

Rasmussen KM, Yaktine AL, eds. Institute of Medicine (2009). Weight Gain During Pregnancy: Reexamining the Guidelines. Committee to Reexamine IOM Pregnancy Weight Guidelines. Washington, DC: National Academy Press.

World Health Organisation (2003). Diet, nutrition and the prevention of chronic diseases. In: World Health Organisation, editor. WHO Technical Report Series. Geneva: World Health Organisation. 2003.  p. 1-149.
}

\keyword{description}