% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ERSex.R
\name{ERSex}
\alias{ERSex}
\title{Ecological representativeness score ex situ}
\usage{
ERSex(
  Species_list,
  Occurrence_data,
  Raster_list,
  Buffer_distance = 50000,
  Ecoregions_shp = NULL,
  Gap_Map = FALSE
)
}
\arguments{
\item{Species_list}{A vector of characters with the species names to calculate the GRSex metrics.}

\item{Occurrence_data}{A data frame object with the species name, geographical coordinates,
and type of records (G or H) for a given species}

\item{Raster_list}{A list of rasters representing the species distribution models for the species list provided
in \var{Species_list}. The order of rasters in this list must match the same order as \var{Species_list}.}

\item{Buffer_distance}{Geographical distance used to create circular buffers around germplasm.
Default: 50000 (50 km) around germplasm accessions (CA50)}

\item{Ecoregions_shp}{A shapefile representing Ecoregions information with a field ECO_ID_U representing Ecoregions Ids.
If Ecoregions=NULL the function will use a shapefile provided for use after running GetDatasets()}

\item{Gap_Map}{logical, if \code{TRUE} the function will calculate gap maps for each species analyzed and
will return a list with with two slots ERSex and gap_maps, or three slots ERSex, buffer_list, and gap_maps}
}
\value{
This function returns a dataframe as main result with two columns:

\tabular{lcc}{
species \tab Species name \cr
ERSex \tab ERSex value calculated\cr
}
}
\description{
The ERSex process provides an ecological measurement of the proportion of a species
 range that can be considered to be conserved in ex situ repositories. The ERSex calculates the
 proportion of terrestrial ecoregions (The Nature Conservancy Geospatial Conservation Atlas 2019)
 represented within the G buffered areas out of the total number of ecoregions occupied by the distribution model.
}
\examples{
##Obtaining occurrences from example
data(CucurbitaData)
Cucurbita_splist <- unique(CucurbitaData$species)
## Obtaining rasterList object. ##
data(CucurbitaRasters)
CucurbitaRasters <- raster::unstack(CucurbitaRasters)
##Obtaining ecoregions shapefile
data(ecoregions)
#Running ERSex
ERSex_df <- ERSex(Species_list = Cucurbita_splist,
                    Occurrence_data = CucurbitaData,
                    Raster_list = CucurbitaRasters,
                    Buffer_distance = 50000,
                    Ecoregions_shp=ecoregions,
                    Gap_Map=FALSE)

}
\references{
Castaneda-Alvarez et al. (2016) Nature Plants 2(4):16022. doi: 10.1038/nplants.2016.22
Khoury et al. (2019) Ecological Indicators 98:420-429. doi: 10.1016/j.ecolind.2018.11.016
The Nature Conservancy Geospatial Conservation Atlas. 2019. Terrestrial Ecoregions
}
