% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauPro_Gauss.R
\docType{class}
\name{GauPro_Gauss}
\alias{GauPro_Gauss}
\title{Corr Gauss GP using inherited optim}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for fitting GP model.
}
\description{
Corr Gauss GP using inherited optim

Corr Gauss GP using inherited optim
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_Gauss$new(X=x, Z=y, parallel=FALSE)
}
\section{Super class}{
\code{\link[GauPro:GauPro]{GauPro::GauPro}} -> \code{GauPro_Gauss}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{corr}}{Name of correlation}

\item{\code{theta}}{Correlation parameters}

\item{\code{theta_length}}{Length of theta}

\item{\code{theta_map}}{Map for theta}

\item{\code{theta_short}}{Short vector for theta}

\item{\code{separable}}{Are the dimensions separable?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_Gauss-new}{\code{GauPro_Gauss$new()}}
\item \href{#method-GauPro_Gauss-corr_func}{\code{GauPro_Gauss$corr_func()}}
\item \href{#method-GauPro_Gauss-deviance_theta}{\code{GauPro_Gauss$deviance_theta()}}
\item \href{#method-GauPro_Gauss-deviance_theta_log}{\code{GauPro_Gauss$deviance_theta_log()}}
\item \href{#method-GauPro_Gauss-deviance}{\code{GauPro_Gauss$deviance()}}
\item \href{#method-GauPro_Gauss-deviance_grad}{\code{GauPro_Gauss$deviance_grad()}}
\item \href{#method-GauPro_Gauss-deviance_fngr}{\code{GauPro_Gauss$deviance_fngr()}}
\item \href{#method-GauPro_Gauss-deviance_log}{\code{GauPro_Gauss$deviance_log()}}
\item \href{#method-GauPro_Gauss-deviance_log2}{\code{GauPro_Gauss$deviance_log2()}}
\item \href{#method-GauPro_Gauss-deviance_log_grad}{\code{GauPro_Gauss$deviance_log_grad()}}
\item \href{#method-GauPro_Gauss-deviance_log2_grad}{\code{GauPro_Gauss$deviance_log2_grad()}}
\item \href{#method-GauPro_Gauss-deviance_log2_fngr}{\code{GauPro_Gauss$deviance_log2_fngr()}}
\item \href{#method-GauPro_Gauss-get_optim_functions}{\code{GauPro_Gauss$get_optim_functions()}}
\item \href{#method-GauPro_Gauss-param_optim_lower}{\code{GauPro_Gauss$param_optim_lower()}}
\item \href{#method-GauPro_Gauss-param_optim_upper}{\code{GauPro_Gauss$param_optim_upper()}}
\item \href{#method-GauPro_Gauss-param_optim_start}{\code{GauPro_Gauss$param_optim_start()}}
\item \href{#method-GauPro_Gauss-param_optim_start0}{\code{GauPro_Gauss$param_optim_start0()}}
\item \href{#method-GauPro_Gauss-param_optim_jitter}{\code{GauPro_Gauss$param_optim_jitter()}}
\item \href{#method-GauPro_Gauss-update_params}{\code{GauPro_Gauss$update_params()}}
\item \href{#method-GauPro_Gauss-grad}{\code{GauPro_Gauss$grad()}}
\item \href{#method-GauPro_Gauss-grad_dist}{\code{GauPro_Gauss$grad_dist()}}
\item \href{#method-GauPro_Gauss-hessian}{\code{GauPro_Gauss$hessian()}}
\item \href{#method-GauPro_Gauss-print}{\code{GauPro_Gauss$print()}}
\item \href{#method-GauPro_Gauss-clone}{\code{GauPro_Gauss$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="cool1Dplot"><a href='../../GauPro/html/GauPro.html#method-GauPro-cool1Dplot'><code>GauPro::GauPro$cool1Dplot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="deviance_searchnug"><a href='../../GauPro/html/GauPro.html#method-GauPro-deviance_searchnug'><code>GauPro::GauPro$deviance_searchnug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="fit"><a href='../../GauPro/html/GauPro.html#method-GauPro-fit'><code>GauPro::GauPro$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_norm'><code>GauPro::GauPro$grad_norm()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="initialize_GauPr"><a href='../../GauPro/html/GauPro.html#method-GauPro-initialize_GauPr'><code>GauPro::GauPro$initialize_GauPr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="loglikelihood"><a href='../../GauPro/html/GauPro.html#method-GauPro-loglikelihood'><code>GauPro::GauPro$loglikelihood()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="nugget_update"><a href='../../GauPro/html/GauPro.html#method-GauPro-nugget_update'><code>GauPro::GauPro$nugget_update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optim"><a href='../../GauPro/html/GauPro.html#method-GauPro-optim'><code>GauPro::GauPro$optim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optimRestart"><a href='../../GauPro/html/GauPro.html#method-GauPro-optimRestart'><code>GauPro::GauPro$optimRestart()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot'><code>GauPro::GauPro$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot1D"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot1D'><code>GauPro::GauPro$plot1D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot2D"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot2D'><code>GauPro::GauPro$plot2D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred'><code>GauPro::GauPro$pred()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_LOO"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_LOO'><code>GauPro::GauPro$pred_LOO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_mean"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_mean'><code>GauPro::GauPro$pred_mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_meanC"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_meanC'><code>GauPro::GauPro$pred_meanC()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_one_matrix"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_one_matrix'><code>GauPro::GauPro$pred_one_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var'><code>GauPro::GauPro$pred_var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="predict"><a href='../../GauPro/html/GauPro.html#method-GauPro-predict'><code>GauPro::GauPro$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="sample"><a href='../../GauPro/html/GauPro.html#method-GauPro-sample'><code>GauPro::GauPro$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update"><a href='../../GauPro/html/GauPro.html#method-GauPro-update'><code>GauPro::GauPro$update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_K_and_estimates"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_K_and_estimates'><code>GauPro::GauPro$update_K_and_estimates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_corrparams"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_corrparams'><code>GauPro::GauPro$update_corrparams()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_data"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_data'><code>GauPro::GauPro$update_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_nugget"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_nugget'><code>GauPro::GauPro$update_nugget()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-new}{}}}
\subsection{Method \code{new()}}{
Create GauPro object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$new(
  X,
  Z,
  verbose = 0,
  separable = T,
  useC = F,
  useGrad = T,
  parallel = FALSE,
  nug = 1e-06,
  nug.min = 1e-08,
  nug.est = T,
  param.est = T,
  theta = NULL,
  theta_short = NULL,
  theta_map = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Matrix whose rows are the input points}

\item{\code{Z}}{Output points corresponding to X}

\item{\code{verbose}}{Amount of stuff to print. 0 is little, 2 is a lot.}

\item{\code{separable}}{Are dimensions separable?}

\item{\code{useC}}{Should C code be used when possible? Should be faster.}

\item{\code{useGrad}}{Should the gradient be used?}

\item{\code{parallel}}{Should code be run in parallel? Make optimization
faster but uses more computer resources.}

\item{\code{nug}}{Value for the nugget. The starting value if estimating it.}

\item{\code{nug.min}}{Minimum allowable value for the nugget.}

\item{\code{nug.est}}{Should the nugget be estimated?}

\item{\code{param.est}}{Should the kernel parameters be estimated?}

\item{\code{theta}}{Correlation parameters}

\item{\code{theta_short}}{Correlation parameters, not recommended}

\item{\code{theta_map}}{Correlation parameters, not recommended}

\item{\code{...}}{Not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-corr_func"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-corr_func}{}}}
\subsection{Method \code{corr_func()}}{
Correlation function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$corr_func(x, x2 = NULL, theta = self$theta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{First point}

\item{\code{x2}}{Second point}

\item{\code{theta}}{Correlation parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_theta"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_theta}{}}}
\subsection{Method \code{deviance_theta()}}{
Calculate deviance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_theta(theta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{Correlation parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_theta_log"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_theta_log}{}}}
\subsection{Method \code{deviance_theta_log()}}{
Calculate deviance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_theta_log(beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter on log scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance}{}}}
\subsection{Method \code{deviance()}}{
Calculate deviance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance(theta = self$theta, nug = self$nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{Correlation parameter}

\item{\code{nug}}{Nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_grad"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_grad}{}}}
\subsection{Method \code{deviance_grad()}}{
Calculate deviance gradient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_grad(
  theta = NULL,
  nug = self$nug,
  joint = NULL,
  overwhat = if (self$nug.est) "joint" else "theta"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{Correlation parameter}

\item{\code{nug}}{Nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}

\item{\code{overwhat}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_fngr"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_fngr}{}}}
\subsection{Method \code{deviance_fngr()}}{
Calculate deviance and gradient at same time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_fngr(
  theta = NULL,
  nug = NULL,
  overwhat = if (self$nug.est) "joint" else "theta"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{Correlation parameter}

\item{\code{nug}}{Nugget}

\item{\code{overwhat}}{Calculate over theta and nug at same time?}

\item{\code{joint}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_log"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_log}{}}}
\subsection{Method \code{deviance_log()}}{
Calculate deviance gradient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_log(beta = NULL, nug = self$nug, joint = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter on log scale}

\item{\code{nug}}{Nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_log2"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_log2}{}}}
\subsection{Method \code{deviance_log2()}}{
Calculate deviance on log scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_log2(beta = NULL, lognug = NULL, joint = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter on log scale}

\item{\code{lognug}}{Log of nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_log_grad"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_log_grad}{}}}
\subsection{Method \code{deviance_log_grad()}}{
Calculate deviance gradient on log scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_log_grad(
  beta = NULL,
  nug = self$nug,
  joint = NULL,
  overwhat = if (self$nug.est) "joint" else "theta"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter}

\item{\code{nug}}{Nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}

\item{\code{overwhat}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_log2_grad"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_log2_grad}{}}}
\subsection{Method \code{deviance_log2_grad()}}{
Calculate deviance gradient on log scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_log2_grad(
  beta = NULL,
  lognug = NULL,
  joint = NULL,
  overwhat = if (self$nug.est) "joint" else "theta"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter}

\item{\code{lognug}}{Log of nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}

\item{\code{overwhat}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-deviance_log2_fngr"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-deviance_log2_fngr}{}}}
\subsection{Method \code{deviance_log2_fngr()}}{
Calculate deviance and gradient on log scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$deviance_log2_fngr(
  beta = NULL,
  lognug = NULL,
  joint = NULL,
  overwhat = if (self$nug.est) "joint" else "theta"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Correlation parameter}

\item{\code{lognug}}{Log of nugget}

\item{\code{joint}}{Calculate over theta and nug at same time?}

\item{\code{overwhat}}{Calculate over theta and nug at same time?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-get_optim_functions"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-get_optim_functions}{}}}
\subsection{Method \code{get_optim_functions()}}{
Get optimization functions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$get_optim_functions(param_update, nug.update)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_update}}{Should the parameters be updated?}

\item{\code{nug.update}}{Should the nugget be updated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-param_optim_lower"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-param_optim_lower}{}}}
\subsection{Method \code{param_optim_lower()}}{
Lower bound of params
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$param_optim_lower()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-param_optim_upper"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-param_optim_upper}{}}}
\subsection{Method \code{param_optim_upper()}}{
Upper bound of params
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$param_optim_upper()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-param_optim_start"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-param_optim_start}{}}}
\subsection{Method \code{param_optim_start()}}{
Start value of params for optim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$param_optim_start()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-param_optim_start0"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-param_optim_start0}{}}}
\subsection{Method \code{param_optim_start0()}}{
Start value of params for optim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$param_optim_start0()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-param_optim_jitter"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-param_optim_jitter}{}}}
\subsection{Method \code{param_optim_jitter()}}{
Jitter value of params for optim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$param_optim_jitter(param_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_value}}{param value to add jitter to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-update_params"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-update_params}{}}}
\subsection{Method \code{update_params()}}{
Update value of params after optim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$update_params(restarts, param_update, nug.update)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restarts}}{Number of restarts}

\item{\code{param_update}}{Are the params being updated?}

\item{\code{nug.update}}{Is the nugget being updated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-grad"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-grad}{}}}
\subsection{Method \code{grad()}}{
Calculate the gradient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$grad(XX)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{Points to calculate grad at}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-grad_dist"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-grad_dist}{}}}
\subsection{Method \code{grad_dist()}}{
Calculate the gradient distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$grad_dist(XX)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{Points to calculate grad at}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-hessian"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-hessian}{}}}
\subsection{Method \code{hessian()}}{
Calculate the hessian
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$hessian(XX, useC = self$useC)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{Points to calculate grad at}

\item{\code{useC}}{Should C code be used to speed up?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
