% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSuppressionFromData.R
\name{MaxContribution}
\alias{MaxContribution}
\title{Find major contributors to aggregates}
\usage{
MaxContribution(x, y, n = 1, decreasing = TRUE, index = FALSE)
}
\arguments{
\item{x}{A (sparse) dummy matrix}

\item{y}{Vector of input values (contributors)}

\item{n}{Number of contributors to be found}

\item{decreasing}{Ordering parameter. Smallest contributors found when \code{FALSE}.}

\item{index}{Indices to \code{y} returned when TRUE}
}
\value{
Matrix with lagest contributors in first column, second largest in second column and so on.
}
\description{
Assuming aggregates are calculated via a dummy matrix by
\code{z = t(x) \%*\% y},
the \code{n} largest contributors are found (value or index) for each aggregate.
}
\examples{
library(SSBtools)

z <- SSBtoolsData("sprt_emp_withEU")
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

a <- ModelMatrix(z, formula = ~age + geo, crossTable = TRUE)

cbind(as.data.frame(a$crossTable), MaxContribution(a$modelMatrix, z$ths_per, 1))
cbind(a$crossTable, MaxContribution(a$modelMatrix, z$ths_per, 10))
cbind(a$crossTable, MaxContribution(a$modelMatrix, z$ths_per, 10, index = TRUE))

b <- ModelMatrix(z[, -4], crossTable = TRUE, inputInOutput = c(TRUE, FALSE, TRUE))

cbind(b$crossTable, MaxContribution(b$modelMatrix, z$ths_per, 10))

}
\seealso{
\code{\link{ModelMatrix}}
}
\author{
Øyvind Langsrud
}
