% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixturePdf.R
\name{GaussianMixturePdf}
\alias{GaussianMixturePdf}
\title{Density function of a mixture of Gaussian univariate distributions}
\usage{
GaussianMixturePdf(x, mu, sigma, w)
}
\arguments{
\item{x}{Points at which the density is comptuted (n x 1);}

\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{w}{vector of the probability of each regime (r x 1).}
}
\value{
\item{f}{Values of the distribution function}
}
\description{
This function computes the density function of a mixture of
Gaussian univariate distributions
}
\examples{
mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05); w <-c(0.8, 0.2);
x <- seq(-1, 1, by = 0.01)
f <- GaussianMixturePdf(x,mu,sigma,w)
plot(x,f,type="l")

}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
