% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwp_functions.R
\name{dwpm}
\alias{dwpm}
\title{Fit density-weighted proportion (DWP) models.}
\usage{
dwpm(data_DWP, type = "data", unitCol = NULL, dwpCols = NULL)
}
\arguments{
\item{data_DWP}{data frame with structure depending on model
type. In general, \code{data_DWP} would be a data frame if a model is to be
fit or if point estimates only are provided as pre-simulated DWP data, and,
if pre-simulated data with variation are provided, then a 2-d array (if one
carcass class) or a list of 2-d arrays (if more than one carcass class). See
"Details" for details.}

\item{type}{model type may be \code{rings}, \code{glm}, \code{TWL}, or
\code{data}. Currently, only the \code{data} type is supported.}

\item{unitCol}{name of the column with the units, which must be non-numeric}

\item{dwpCols}{name(s) of the columns with the DWP data}
}
\value{
an object of an object of class \code{dwpm}, which is a list with
 model \code{type} (currently only \code{type = data} is supported) and
 \code{model}, which gives the simulated DWP values as an array (if there's
 only a single carcass class) or a list of arrays (if there are more than one
 carcass classes).
}
\description{
Carcass density is modeled as a function of distance from
 turbine. Format and usage parallel that of common \code{R} functions
 \code{lm}, \code{glm}, and \code{gam} and the GenEst functions \code{pkm}
 and \code{cpm}.
}
\details{
The fraction of carcasses falling in the area searched at a turbine
 may be a function of carcass class (e.g., large or small) and/or direction
 from the turbine. Data may be provided for fitting a distance model(s) or,
 alternatively, simulated turbine-wise DWP data from custom-fitted models may
 be provided. If pre-fit, pre-simulated data are used, then \code{glm} returns
 a \code{dwpm} object with \code{type = data}.

 To fit a model, \code{data_DWP} should be a data frame with a row for each carcass
 and columns giving (at a minimum) unique carcass IDs, turbine ID, distance
 from turbine, and fraction of area searched at the given distance at the
 given turbine. Optional columns may include carcass class, covariates that may
 influence detection probability (e.g., visibility class), and direction.
 If covariates are to be included in the model, then the fraction of area
 column would give the fraction of the area in the given covariate level at
 that distance. Alternatively, prefab data may be provided in a dataframe,
 with structure depending on data type. The simplest case would be that
 point estimates only are provided. In that case, if there are no distinctions
 among carcass classes (e.g., size), then \code{data_DWP} should be a dataframe
 with one column giving the unit (e.g., turbine) and one column with the DWP
 at each unit; if distinctions are made among carcass classes, then \code{data_DWP} would
 be a data frame with a unit column and a DWP column for each carcass class. If
 the DWP estimates incorporate uncertainties, then \code{data_DWP} should be
 an array with \code{n_unit * nsim} rows and with colunms for units and DWPs for
 each carcass class.
}
