% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stat_summary}
\alias{stat_summary}
\title{Generate Summary Statistics for Genomic Elements}
\usage{
stat_summary(input, type, verbose = TRUE)
}
\arguments{
\item{input}{A data frame containing classified exons or introns. For exons, must include \code{EXON_CLASSIFICATION}. For introns, requires classification columns.}

\item{type}{A character string specifying the element type. Valid options: \code{"exon"} or \code{"intron"}.}

\item{verbose}{A logical indicating whether to print progress messages. Defaults to \code{TRUE}.}
}
\value{
A data frame with summary statistics for each element group, including mean, median, standard deviation, standard error, quartiles, and sample size.
}
\description{
Calculates descriptive summary statistics (mean, median, standard deviation, etc.) for the lengths of exons or introns, grouped by classification (e.g., first exon, inner intron).
}
\details{
For exons, statistics are grouped by \code{EXON_CLASSIFICATION}. For introns, groups include \code{first_intron}, \code{inner_intron}, and splice site types (e.g., \code{gc_intron}).
}
\examples{
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
# Exon statistics
exon_stats <- stat_summary(gtf_v1, type = "exon")


}
