% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_gt_data.R
\name{separateByPopulations}
\alias{separateByPopulations}
\title{Separate Genotype Matrix by Populations}
\usage{
separateByPopulations(
  sep_gt,
  pop1_names,
  pop2_names,
  ploidy = 2,
  rm_ref_alleles = TRUE
)
}
\arguments{
\item{sep_gt}{A genotype matrix similar to the \verb{@sep_gt} slot of a \code{vcfR} object.}

\item{pop1_names}{A character vector of individual names for the first population.}

\item{pop2_names}{A character vector of individual names for the second population.}

\item{rm_ref_alleles}{Logical, whether variants that only have the reference allele
should be removed from the respective subpopulations data frame. (Default = TRUE)}
}
\value{
A list containing two data frames, one for each population.
}
\description{
This function separates a genotype matrix into two data frames based on population assignments.
It's designed to work with the batches or windows processed by \code{process_vcf_in_batches} and \code{process_vcf_in_windows}.
}
\keyword{internal}
