% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPED.R
\name{importPED}
\alias{importPED}
\title{importPED}
\usage{
importPED(file, n, snps = NULL, which, split = "\\t| +", sep = ".",
  na.strings = "0", lex.order = FALSE, verbose = TRUE)
}
\arguments{
\item{file}{ped filename}

\item{n}{Number of samples to read}

\item{snps}{map filename}

\item{which}{Names of SNPS to import}

\item{split}{Columns separator in ped file}

\item{sep}{Character that separates Alleles}

\item{na.strings}{Definition for missing values}

\item{lex.order}{Logical, lexicographical order}

\item{verbose}{Logical, verbose output}
}
\value{
a pedmap object
}
\description{
Import a PED/MAP file pair
}
\details{
This function is to a large extend taken from \code{snpStat::read.pedmap}, but here is internally the \code{data.table::fread} function used
that resulted in much faster file processing.

To import the data, the ped file can be provided to the \code{file} option and the map file to the \code{snps} option. If no option is given to
\code{snps} and the \code{file} option is provided without any file extension, then the ped/map extension are automaticall added
}
\examples{

 # Define here the location on HDD for the example file
   pedPath <- system.file("extdata","example.ped", package="GenomicTools.fileHandler")
   mapPath <- system.file("extdata","example.map", package="GenomicTools.fileHandler")
 # Import the example ped/map files  
   importPED(file=pedPath, snps=mapPath)


}
\author{
Daniel Fischer
}
