% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoning.R
\docType{class}
\name{Zoning}
\alias{Zoning}
\title{Class "Zoning"}
\description{
The main class to perform zoning\cr
More information is available in the vignette "Zoning with GeoFIS"
}
\examples{
library(GeoFIS)

data(conductivity_2014)
data(conductivity_border)
zoning <- NewZoning(conductivity_2014)
zoning$border <- conductivity_border
zoning$neighborhood <- 5
zoning$perform_zoning()
map5 <- zoning$map(5)

# plot the map
library(RColorBrewer)
palette <- brewer.pal(3, "Blues")
breaks <- c(30, 50, 70, 100)
colors <- palette[findInterval(map5$conduct_mean, vec = breaks)]
par(mar = c(0, 0, 2, 0))
plot(map5, col = colors, main = "Map 5 zones")
legend("bottomright", legend = levels(cut(map5$conduct_mean, breaks)),
  fill = palette, title = "Conductivity mean")

# export the map as Shapefile (replace tempdir() with the directory you want to put the map)
library(rgdal)
writeOGR(map5, dsn = tempdir(), layer = "map5", driver = "ESRI Shapefile")
}
\references{
{
\insertRef{Pedroso10}{GeoFIS}

\insertRef{Infsci13}{GeoFIS}

\insertRef{fuzzieee13}{GeoFIS}
}
}
\seealso{
{
\link{NewZoning}

\href{https://www.geofis.org/en/documentation-en/zoning/}{Zoning documentation}
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{border}}{\link{SpatialPolygons} object, The border used to limit the processed area, or \code{NULL} if the Convex Hull of data source is used\cr
Only data points within the border polygon are processed\cr
The default value is \code{NULL}}

\item{\code{neighborhood}}{\link{numeric} value, The minimum edge length shared by two Voronoi polygons for being considered as neighbors\cr
or \code{NULL} if all contiguous Voronoi polygons are considered as neighbors\cr
The default value is \code{NULL}}

\item{\code{attribute_distance}}{\link{list} of Distance object (write-only), The functions used to compute the distance between two data points in the attribute space\cr
The length of the list must be equal to the number of zonable attributes, the distance objects are treated in the order of zonable attributes\cr
In case of a single attribute into the zonable dataset, the \link{list} is optional and a single Distance object can be provided\cr
Allowed distance objects: \link{EuclideanDistance}, \link{FuzzyDistance} or \code{NULL} if the attribute should not be used in the zoning process\cr
The default value is a \link{list} of \link{EuclideanDistance}\cr
See \href{https://www.geofis.org/en/documentation-en/zoning/#main-parameters}{Zoning documentation main parameters} univariate distance\cr}

\item{\code{combine_distance}}{Distance object (write-only), The function used to combine attribute distances in case of multivariate zoning\cr
Allowed distance objects: \link{EuclideanDistance} or \link{MinkowskiDistance}\cr
The default value is \link{EuclideanDistance}
See \href{https://www.geofis.org/en/documentation-en/zoning/#main-parameters}{Zoning documentation main parameters} multivariate combination\cr}

\item{\code{zone_distance}}{Distance object (write-only), The function used to compute the distance between 2 zones\cr
Allowed distance objects: \link{MaximumDistance}, \link{MinimumDistance} or \link{MeanDistance}\cr
The default value is \link{MaximumDistance}\cr
The pair of zones to be merged are those for which the \code{zone_distance} is minimum.\cr
See \href{https://www.geofis.org/en/documentation-en/zoning/#main-parameters}{Zoning documentation main parameters} between zone distance\cr}

\item{\code{smallest_zone}}{Smallest zone object (write-only), This criterion is used to determine the smallest size for a zone (number of points or area) to be kept in the final map\cr
Allowed Smallest zone objects: \link{ZoneSize} or \link{ZoneArea}\cr
The default value is \link{ZoneSize} with 1 point}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Zoning$new()}}
\item \href{#method-zonable_data}{\code{Zoning$zonable_data()}}
\item \href{#method-perform_voronoi}{\code{Zoning$perform_voronoi()}}
\item \href{#method-voronoi_map}{\code{Zoning$voronoi_map()}}
\item \href{#method-perform_neighborhood}{\code{Zoning$perform_neighborhood()}}
\item \href{#method-neighborhood_map}{\code{Zoning$neighborhood_map()}}
\item \href{#method-perform_zoning}{\code{Zoning$perform_zoning()}}
\item \href{#method-map_size}{\code{Zoning$map_size()}}
\item \href{#method-map}{\code{Zoning$map()}}
\item \href{#method-maps}{\code{Zoning$maps()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Constructor, create a new instance of \link{Zoning}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$new(source, warn = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{\link{SpatialPointsDataFrame} or \link{SpatialMultiPointsDataFrame} object, The data source}

\item{\code{warn}}{\link{logical} value, Show warnings if TRUE, default value is TRUE}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zonable_data"></a>}}
\if{latex}{\out{\hypertarget{method-zonable_data}{}}}
\subsection{Method \code{zonable_data()}}{
Get the zonable data\cr
Keep only the attributes that can be used in the zoning process, meaning numeric atributes, without missing values and with a range that is not limited to a unique value\cr
The last condition is required by the min-max standardization process
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$zonable_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{SpatialPointsDataFrame} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-perform_voronoi"></a>}}
\if{latex}{\out{\hypertarget{method-perform_voronoi}{}}}
\subsection{Method \code{perform_voronoi()}}{
Compute the Voronoi diagram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$perform_voronoi()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-voronoi_map"></a>}}
\if{latex}{\out{\hypertarget{method-voronoi_map}{}}}
\subsection{Method \code{voronoi_map()}}{
Get the Voronoi map
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$voronoi_map()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{SpatialPolygons} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-perform_neighborhood"></a>}}
\if{latex}{\out{\hypertarget{method-perform_neighborhood}{}}}
\subsection{Method \code{perform_neighborhood()}}{
Identify adjacent polygons in the voronoi tesselation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$perform_neighborhood()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-neighborhood_map"></a>}}
\if{latex}{\out{\hypertarget{method-neighborhood_map}{}}}
\subsection{Method \code{neighborhood_map()}}{
Get the neighborhood map
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$neighborhood_map()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{SpatialLinesDataFrame} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-perform_zoning"></a>}}
\if{latex}{\out{\hypertarget{method-perform_zoning}{}}}
\subsection{Method \code{perform_zoning()}}{
Perform the zoning
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$perform_zoning()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-map_size"></a>}}
\if{latex}{\out{\hypertarget{method-map_size}{}}}
\subsection{Method \code{map_size()}}{
Get the number of maps with different number of zones available after perform zoning
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$map_size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{integer} value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-map"></a>}}
\if{latex}{\out{\hypertarget{method-map}{}}}
\subsection{Method \code{map()}}{
Get the map corresponding to a number of zones
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$map(number_of_zones)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number_of_zones}}{\link{integer} value, The number of zones in the map}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{SpatialPolygonsDataFrame} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-maps"></a>}}
\if{latex}{\out{\hypertarget{method-maps}{}}}
\subsection{Method \code{maps()}}{
Get the maps corresponding to a number of zones
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Zoning$maps(number_of_zones)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number_of_zones}}{\link{integer} vector, The number of zones in each map}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{list} of \link{SpatialPolygonsDataFrame} object
}
}
}
