% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexes.R
\name{ger_MGR}
\alias{ger_MGR}
\title{Mean Germination Rate}
\usage{
ger_MGR(evalName, data)
}
\arguments{
\item{evalName}{Prefix of the names of the periods of evaluation.}

\item{data}{The name of the data frame containing the data.}
}
\value{
It returns an vector with the values of Mean Germination Rate
}
\description{
This function calculates the mean germination rate of the germination.
}
\details{
The average speed of germination is defined as the reciprocal of the average time germination (RANAL; SANTANA, 2006).
}
\examples{

library(GerminaR)
dt <- prosopis
mgr <- ger_MGR(evalName = "D", data = dt)
mgr
}
\references{
RANAL, M. A.; SANTANA, D. G. DE. How and why to measure the germination process? 
Revista Brasileira de Botanica, v. 29, n. 1, p. 1-11, mar. 2006.
}
