% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_download_file.R
\name{ghfd_download_file}
\alias{ghfd_download_file}
\title{Downloads a single file from Bovespa ftp}
\usage{
ghfd_download_file(my.ftp, out.file, dl.dir = "Dl Files", max.dl.tries = 10)
}
\arguments{
\item{my.ftp}{A complete, including file name, ftp address to download the file from}

\item{out.file}{Name of downloaded file with HFT data from Bovespa}

\item{dl.dir}{The folder to download the zip files (default = 'ftp files')}

\item{max.dl.tries}{Maximum attempts to download the files from ftp}
}
\value{
TRUE if sucessfull, FALSE if not
}
\description{
This function will take as input a ftp addresss, the name of the downloaded file in the local drive,
and it will download the corresponding file. Returns TRUE if it worked and FALSE otherwise.
}
\examples{

my.ftp <- 'ftp://ftp.bmf.com.br/MarketData/Bovespa-Opcoes/NEG_OPCOES_20151229.zip'
out.file <- 'temp.zip'

\dontrun{
ghfd_download_file(my.ftp = my.ftp, out.file=out.file)
}
}
