% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNonlinearity.R
\name{prNlChooseDf}
\alias{prNlChooseDf}
\title{Chooses the degrees of freedom for the non-linearity}
\usage{
prNlChooseDf(model, flex_param, variable, spline_fn, min_fn,
  simplest_nonlinear, verbal, workers, libraries)
}
\arguments{
\item{model}{The model that is to be evaluated and adatpted for non-linearity}

\item{flex_param}{A \code{vector} with values that are to be tested as the 
default second parameter for the non-linearity function that you want to 
evaluate. This defaults to 2:7, for the \code{\link[splines]{ns}()} it tests 
the degrees of freedom ranging between 2 and 7.}

\item{variable}{The name of the parameter that is to be tested for non-linearity.
\emph{Note} that the variable should be included plain (i.e. as a linear variable)
form in the model.}

\item{spline_fn}{Either a string or a function that is to be used
for testing alternative non-linearity models}

\item{min_fn}{This is the function that we want to minmized if the variable supports
the non-linearity assumption. E.g. \code{\link[stats]{BIC}()} or 
\code{\link[stats]{AIC}}, note that the \code{\link[stats]{BIC}()} will in the majority of cases
support a lower complexity than the \code{\link[stats]{AIC}()}.}

\item{simplest_nonlinear}{The simplest non-linear form that the ANOVA has been tested against}

\item{verbal}{Set this to \code{TRUE} if you want print statements with the
anova test and the chosen knots.}

\item{workers}{The function tries to run everything in parallel. Under some
circumstances you may want to restrict the number of parallel threads to less
than the defaul \code{\link[parallel]{detectCores}() - 1}, e.g. you may run out of memory
then you can provide this parameter. If you do not want to use parallel then 
simply set workers to \code{FALSE}. The cluster created using \code{\link[parallel]{makeCluster}()} 
function.}

\item{libraries}{If we use the parallel approach we need to make sure that the 
right libraries are available in the threads}
}
\description{
Looks for the model with the minimal \code{min_fn} within the flex_param span.
}
\keyword{internal}
