% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_decomp_level}
\alias{process_decomp_level}
\title{Process Decomposition Levels in Data Frames (Internal)}
\usage{
process_decomp_level(df, subtotal_level)
}
\arguments{
\item{df}{A data frame containing a \code{"Subtotal"} column.}

\item{subtotal_level}{Character or logical. Determines which values to retain:
\itemize{
\item \code{"total"}: Keeps only \code{"TOTAL"} values.
\item \code{"decomposed"}: Keeps only decomposed values (excludes \code{"TOTAL"}).
\item \code{"all"}: Keeps all rows.
\item \code{TRUE}: Equivalent to \code{"all"} (keeps both \code{"TOTAL"} and decomposed values).
\item \code{FALSE}: Equivalent to \code{"total"} (keeps only \code{"TOTAL"} values, removing decomposed components).
}}
}
\value{
A filtered data frame based on the specified decomposition level.
}
\description{
A helper function that filters data based on decomposition levels in the \code{"Subtotal"} column.
Used internally in \code{get_data_by_var()}, \code{get_data_by_dims()}, and \code{group_data_by_dims()}.
}
\details{
\itemize{
\item If \code{subtotal_level = "total"}, \strong{keeps only \code{"TOTAL"} values}, removing all decomposed components.
\item If \code{subtotal_level = "decomposed"}, \strong{keeps only decomposed components}, removing \code{"TOTAL"}.
\item If \code{subtotal_level = "all"}, \strong{keeps both \code{"TOTAL"} and decomposed values} (no filtering).
\item If \code{subtotal_level = TRUE} (logical), it is \strong{equivalent to \code{"all"}}, meaning all values are kept.
\item If \code{subtotal_level = FALSE} (logical), it is \strong{equivalent to \code{"total"}}, meaning only \code{"TOTAL"} values are kept, and decomposed components are removed.
\item Filtering is applied \strong{only when both \code{"TOTAL"} and decomposed values exist}.
}
}
\seealso{
\code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}, \code{\link{group_data_by_dims}}
}
\author{
Pattawee Puangchit
}
\keyword{internal}
