% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation_export.R
\name{pivot_data}
\alias{pivot_data}
\title{Pivot Data from SL4 or HAR Objects}
\usage{
pivot_data(data_obj, pivot_cols, name_repair = "unique")
}
\arguments{
\item{data_obj}{A list or data frame. The SL4 or HAR data to pivot.}

\item{pivot_cols}{Character vector. Column names to use as pivot keys.}

\item{name_repair}{Character. Method for handling duplicate column names (\code{"unique"}, \code{"minimal"}, \code{"universal"}). Default is \code{"unique"}.}
}
\value{
A transformed data object where the specified \code{pivot_cols} are pivoted into wide format.
}
\description{
Transforms long-format SL4 or HAR data into wide format by pivoting selected columns.
Supports both single data frames and nested lists.
}
\details{
\itemize{
\item Uses \code{tidyr::pivot_wider()} internally to reshape data.
\item Allows multiple columns to be pivoted simultaneously.
\item Recursively processes nested lists, ensuring all data frames are transformed.
}
}
\examples{
# Import sample data:
sl4_data <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))

# Extract multiple variables
data_multiple <- get_data_by_var(c("qo", "qxs"), sl4_data)

# Pivot a single column
pivoted_data <- pivot_data(data_multiple, pivot_cols = "REG")

# Pivot multiple columns
pivoted_data_multi <- pivot_data(data_multiple, pivot_cols = c("REG", "COMM"))

}
\seealso{
\code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
