% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_Inspect.R
\name{single_Inspect}
\alias{single_Inspect}
\title{Inspect for single change-point estimation}
\usage{
single_Inspect(
  X,
  lambda = sqrt(log(p * log(n))/2),
  eps = 1e-10,
  rescale_variance = FALSE,
  maxiter = 10000,
  debug = FALSE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{lambda}{Manually specified value of \eqn{\lambda} (can be \code{NULL}, in which case \eqn{\lambda \gets \sqrt{\log(p\log n)/2}})}

\item{eps}{Threshold for declaring numerical convergence of the power method}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{maxiter}{Maximum number of iterations for the power method}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing 
  \item{pos}{estimated change-point location}
  \item{CUSUMval}{projected CUSUM value at the estimated change-point position}
}
\description{
R wrapper for C function for single change-point estimation using Inspect \insertCite{wang_high_2018}{HDCD}. Note that the algorithm is only implemented for \eqn{\mathcal{S} = \mathcal{S}_2}, in the notation of \insertCite{wang_high_2018;textual}{HDCD}.
}
\examples{
library(HDCD)
n = 500
p = 500
set.seed(101)
# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# Adding a single sparse change-point:
X[1:5, 201:500] = X[1:5, 201:500] +1

res = single_Inspect(X,rescale_variance=TRUE)
res$pos

# Manually setting the value of \lambda:
res = single_Inspect(X, lambda = 2*sqrt(log(p*log(n))/2))
res$pos
}
\references{
\insertAllCited{}
}
