% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_SD2008.R
\name{ts_sd2008}
\alias{ts_sd2008}
\title{Test proposed by Srivastava and Du (2008)}
\usage{
ts_sd2008(y1, y2)
}
\arguments{
\item{y1}{The data matrix (p by n1) from the first population. Each column represents a \eqn{p}-dimensional observation.}

\item{y2}{The data matrix (p by n2) from the first population. Each column represents a \eqn{p}-dimensional observation.}
}
\value{
A  (list) object of  \code{S3} class \code{htest}  containing the following elements:
\describe{
\item{statistic}{the test statistic proposed by Srivastava and Du (2008).}
\item{p.value}{the \eqn{p}-value of the test proposed by Srivastava and Du (2008).}
\item{cpn}{the adjustment coefficient proposed by Srivastava and Du (2008).}
}
}
\description{
Srivastava and Du (2008)'s test for testing equality of two-sample high-dimensional mean vectors with assuming that two covariance matrices are the same.
}
\details{
Suppose we have two independent high-dimensional samples:
\deqn{
\boldsymbol{y}_{i1},\ldots,\boldsymbol{y}_{in_i}, \;\operatorname{are \; i.i.d. \; with}\; \operatorname{E}(\boldsymbol{y}_{i1})=\boldsymbol{\mu}_i,\; \operatorname{Cov}(\boldsymbol{y}_{i1})=\boldsymbol{\Sigma},i=1,2.
}
The primary object is to test
\deqn{H_{0}: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2\; \operatorname{versus}\; H_{1}: \boldsymbol{\mu}_1 \neq \boldsymbol{\mu}_2.}
Srivastava and Du (2008) proposed the following test statistic:
\deqn{T_{SD} = \frac{n^{-1}n_1n_2(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2)^\top \boldsymbol{D}_S^{-1}(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2) - \frac{(n-2)p}{n-4}}{\sqrt{2 \left[\operatorname{tr}(\boldsymbol{R}^2) - \frac{p^2}{n-2}\right] c_{p, n}}},}
where \eqn{\bar{\boldsymbol{y}}_{i},i=1,2} are the sample mean vectors,  \eqn{\boldsymbol{D}_S} is the diagonal matrix of sample variance, \eqn{\boldsymbol{R}} is the sample correlation matrix and \eqn{c_{p, n}} is the adjustment coefficient proposed by Srivastava and Du (2008).
They showed that under the null hypothesis, \eqn{T_{SD}} is asymptotically normally distributed.
}
\examples{
set.seed(1234)
n1 <- 20
n2 <- 30
p <- 50
mu1 <- t(t(rep(0, p)))
mu2 <- mu1
rho <- 0.1
y <- (-2 * sqrt(1 - rho) + sqrt(4 * (1 - rho) + 4 * p * rho)) / (2 * p)
x <- y + sqrt((1 - rho))
Gamma <- matrix(rep(y, p * p), nrow = p)
diag(Gamma) <- rep(x, p)
Z1 <- matrix(rnorm(n1 * p, mean = 0, sd = 1), p, n1)
Z2 <- matrix(rnorm(n2 * p, mean = 0, sd = 1), p, n2)
y1 <- Gamma \%*\% Z1 + mu1 \%*\% (rep(1, n1))
y2 <- Gamma \%*\% Z2 + mu2 \%*\% (rep(1, n2))
ts_sd2008(y1, y2)

}
\references{
\insertRef{Srivastava_2008}{HDNRA}
}
\concept{ts}
