% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cvEM.R
\name{EMcvlasso}
\alias{EMcvlasso}
\title{cross validation for EM lasso}
\usage{
EMcvlasso(X, y, nbFolds = 10, lambda = NULL, maxSteps = 1000, burn = 30,
  intercept = TRUE, model = "linear", threshold = .Machine$double.eps^0.5,
  eps = 1e-05, epsCG = 1e-08)
}
\arguments{
\item{X}{the matrix (of size n*p) of the covariates.}

\item{y}{a vector of length n with the response.}

\item{nbFolds}{the number of folds for the cross-validation.}

\item{lambda}{Values at which prediction error should be computed.}

\item{maxSteps}{Maximal number of steps for EM algorithm.}

\item{burn}{Number of steps for the burn period.}

\item{intercept}{If TRUE, there is an intercept in the model.}

\item{model}{"linear" or "logistic".}

\item{threshold}{zero tolerance.}

\item{eps}{Tolerance of the algorithm.}

\item{epsCG}{Epsilon for the convergence of the conjugate gradient.}
}
\value{
A list containing
\describe{
  \item{cv}{Mean prediction error for each value of index.}
  \item{cvError}{Standard error of cv.}
  \item{minCv}{Minimal cv criterion.}
  \item{lambda}{Values of lambda at which prediction error should be computed.}
  \item{lambda.optimal}{Value of lambda for which the cv criterion is minimal.}
}
}
\description{
cross validation function for EM lasso.
}
\examples{
#dataset=simul(50,100,0.4,1,10,matrix(c(0.1,0.8,0.02,0.02),nrow=2))
#result=EMcvlasso(dataset$data,dataset$response,5,lambda=5:1,intercept=FALSE)
}
\author{
Quentin Grimonprez
}

