#' Lockdown dates from Ballotpedia
#'
#' Start and end dates of statewide stay at home orders in response to the
#' Covid-19 pandemic.
#'
#' @format A data frame with 50 rows and 3 variables:
#' \describe{
#'   \item{State}{State}
#'   \item{Lockdown_Start}{Start date of the statewide order in YYYY-MM-DD
#'   format}
#'   \item{Lockdown_End}{End date of the statewide order in YYYY-MM-DD
#'   format}
#' }
#'
#' @source 
#' States that issued lockdown and stay-at-home orders in response to the 
#' coronavirus (COVID-19) pandemic, 2020.
#' \url{https://ballotpedia.org/States_that_issued_lockdown_and_stay-at-home_orders_in_response_to_the_coronavirus_(COVID-19)_pandemic,_2020}
"lockdowndates"
