% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot_summary_chart}
\alias{plot_summary_chart}
\title{Plots the mean or median spider chart of the clusters (multivariate non-functional data)}
\usage{
plot_summary_chart(
  output_clusters,
  data,
  variable_names = NULL,
  type = "mean",
  colors = "red"
)
}
\arguments{
\item{output_clusters}{list. List of the sites in the clusters: it is the sites_clusters of the output of NPFSS, PFSS, DFFSS, URBFSS, MDFFSS, MRBFSS, MG, MNP, UG or UNP, or the sites_clusters_LH/sites_clusters_W/sites_clusters_P/sites_clusters_R of the MPFSS.}

\item{data}{matrix. Matrix of the data, the rows correspond to the sites (or to the individuals) and each column represents a variable.}

\item{variable_names}{character vector. The names of the variables if you want the names to appear. By default NULL: the names are var1, var2, etc.}

\item{type}{character. "mean" or "median". If "mean": the mean curves in the clusters are plotted in solid lines, outside the cluster in dots, the global mean curve is in black. If "median": the median curves in the clusters are plotted in solid lines, outside the cluster in dots, the global median curve is in black.}

\item{colors}{character. The colors to plot the clusters' summary curves. If length(colors)==1 then all the clusters will be plotted in this color. Else there must be the same number of elements in colors than the number of clusters}
}
\value{
No value returned, plots the spider chart.
}
\description{
This function plots the mean or median spider chart of the clusters. Only for multivariate non-functional data.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("multi_data")
coords <- coordinates(map_sites)

res_mnp <- MNP(data=multi_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)

plot_summary_chart(output_clusters = res_mnp$sites_clusters,
data = multi_data, type = "mean")}
\dontshow{
library(sp)
data("map_sites")
data("multi_data")
indices <- which(map_sites$NAME_3 == "Lille")
coords <- coordinates(map_sites[indices,])
res_mnp <- MNP(data=multi_data[indices,], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)
if(length(res_mnp$sites_clusters)>0){
plot_summary_chart(output_clusters = res_mnp$sites_clusters,
data = multi_data[indices,], type = "mean")
}
}

}
