% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI.R
\name{CI_2pts}
\alias{CI_2pts}
\title{Global confidence interval treshold from experimental standard deviation for 2 samples.}
\usage{
CI_2pts(s1, s2, replicates = 3)
}
\arguments{
\item{s1}{standard deviation from one sample}

\item{s2}{standard deviation from seconda sample}

\item{replicates}{number of replicates. Default set to 3.}
}
\value{
treshold for determining significance.
}
\description{
Calculation of global confidence interval using approach by:
Reliable Identification of Significant Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements Using a Hybrid Significance Testing Approach
Tyler S. Hageman and David D. Weis
Analytical Chemistry 2019 91 (13), 8008-8016 DOI: 10.1021/acs.analchem.9b01325
calculations for alpha 0.99
}
\examples{
sd1<-data.frame(c(0.1, 0.12, 0.13, 0.09, 0.11, 0.10))
sd2<-data.frame(c(0.18, 0.11, 0.13, 0.08, 0.11, 0.06))
CI_2pts(s1=sd1, s2=sd2, replicates=3)
}
