% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{tupla.matrix}
\alias{tupla.matrix}
\title{Tupla Matrix}
\usage{
tupla.matrix(m, compressed = TRUE, output.file = "net.file.gz")
}
\arguments{
\item{m}{a weighetd adjacency matrix of the graph. Rows and columns are examples. It must be a square named matrix.}

\item{compressed}{boolean value:
\itemize{
\item TRUE (def.): the output file will be a \code{gz} compressed format;
\item FALSE: the output file will be a plain \code{text} format;
}}

\item{output.file}{name of the file of the  to be written}
}
\value{
if \code{compressed=TRUE} the weighted adjacency matrix as tupla is stored in a compressed \code{gz}, 
otherwise (\code{compressed=FALSE}) it is stored in a plain \code{text} file.
}
\description{
Trasform a Weighted Adjacency Matrix (wadj matrix) of a graph in a tupla, i.e. as a sequences of rows separated by 
blank and the weight of the edges, e.g \code{nodeX nodeY score}
}
\details{
Only the \emph{non-zero} interactions are kept, while the \emph{zero} interactions are discarded. 
In other words in the \code{output.file} are reported only those nodes having a weight different from zero
}
\examples{
\dontrun{
data(wadj);
tupla.matrix(W,compressed=TRUE, output.file="tupla.wadj.gz");
tupla.matrix(W,compressed=FALSE, output.file="tupla.wadj.txt");}
}
