% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkGeneSymbols.R
\name{checkGeneSymbols}
\alias{checkGeneSymbols}
\title{Identify outdated or Excel-mogrified gene symbols}
\usage{
checkGeneSymbols(
  x,
  chromosome = NULL,
  unmapped.as.na = TRUE,
  map = NULL,
  species = "human",
  expand.ambiguous = FALSE
)
}
\arguments{
\item{x}{A character vector of gene symbols to check for modified or outdated values}

\item{chromosome}{An optional integer vector containing the chromosome number of each gene
provided through the argument \code{x}. It should be the 
same length as the input for \code{x}. Currently, this argument is implemented
only for human gene cases.}

\item{unmapped.as.na}{If \code{TRUE} (default), unmapped symbols will appear as 
NA in the \code{Suggested.Symbol} column. If \code{FALSE}, the original unmapped 
symbol will be kept.}

\item{map}{Specify if you do not want to use the default maps provided by setting 
species equal to "mouse" or "human". Map can be any other data.frame with colnames 
identical to \code{c("Symbol", "Approved.Symbol")}. The default maps can be updated 
by running the interactive example below.}

\item{species}{A character vector of length 1, either "human" (default) or "mouse". 
If \code{NULL}, or anything other than "human" or "mouse", then the map argument 
must be provided.}

\item{expand.ambiguous}{If \code{FALSE} (default), genes with multiple mapping will only 
map to its approved symbol as the correct one. If \code{TRUE}, genes with multiple/ambiguous mapping
will map to all the symbols linked to it.}
}
\value{
The function will return a data.frame of the same number of rows as the 
input, with corrections possible from map.
}
\description{
This function identifies gene symbols which are outdated or may 
have been mogrified by Excel or other spreadsheet programs. If output is assigned 
to a variable, it returns a data.frame of the same number of rows as the input, 
with a second column indicating whether the symbols are valid and a third column 
with a corrected gene list.
}
\examples{
library(HGNChelper)

## Human
human <- c("FN1", "TP53", "UNKNOWNGENE","7-Sep", "9/7", "1-Mar", "Oct4", "4-Oct",
      "OCT4-PG4", "C19ORF71", "C19orf71")
checkGeneSymbols(human)

## Mouse
mouse <- c("1-Feb", "Pzp", "A2m")
checkGeneSymbols(mouse, species="mouse")

## expand.ambiguous

## Human
human <- "AAVS1"
checkGeneSymbols(human, expand.ambiguous=FALSE)
checkGeneSymbols(human, expand.ambiguous=TRUE)

## Mouse
mouse <- c("Cpamd8", "Mug2")
checkGeneSymbols(mouse, species = "mouse", expand.ambiguous = FALSE)
checkGeneSymbols(mouse, species = "mouse", expand.ambiguous = TRUE)

## Updating the map
if (interactive()) {
    currentHumanMap <- getCurrentHumanMap()
    checkGeneSymbols(human, map=currentHumanMap)

    # You should save this if you are going to use it multiple times,   
    # then load it from file rather than burdening HGNC's servers.
    save(hgnc.table, file="hgnc.table.rda", compress="bzip2")
    load("hgnc.table.rda")
    checkGeneSymbols(human, map=hgnc.table)
}
  
}
\seealso{
\code{\link{mouse.table}} for the mouse lookup table, \code{\link{hgnc.table}} for the human lookup table
}
