% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchandBuildAlignments.R
\name{uniSearch}
\alias{uniSearch}
\title{Search Sequences at a Single Position for an Allele}
\usage{
uniSearch(alignType, locus, allele, position, prefix = TRUE, trimmed = FALSE)
}
\arguments{
\item{alignType}{The type of alignment being searched. Allowed values are "prot", "codon", "nuc" and "gen". Only one 'alignType' value is allowed.}

\item{locus}{A specific HLA locus.}

\item{allele}{The name of the allele being searched.}

\item{position}{The specified position.}

\item{prefix}{A logical that indicates if the position number(s) should be included in the result.}

\item{trimmed}{A logical identifying whether 'allele' is a two-field, 'trimmed' allele name (trimmed=TRUE), or a full-length name (trimmed=FALSE). The default value is FALSE.}
}
\value{
The peptide residue, codon or nucleotide sequence at specified position for specified allele as available in the ANHIG/IMGTHLA Github Repository.
}
\description{
Generates a character string of the peptide, codon or nucleotide sequence at the specified position for the specified HLA allele.
}
\note{
For internal HLAtools use.
}
