% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchandBuildAlignments.R
\name{validatePositions}
\alias{validatePositions}
\title{Validate the Presence of Variant Positions in an Alignment}
\usage{
validatePositions(alignType, locus, positions)
}
\arguments{
\item{alignType}{The type of alignment being searched. Allowed values are "prot", codon", "nuc" and "gen".  Only one 'alignType' value is allowed.}

\item{locus}{A locus supported by the IPD-IMGT/HLA Database.}

\item{positions}{A vector of variant positions.}
}
\value{
A logical identifying if the position is present in the alignment (TRUE) or, if it is not in the alignment or is not valid (FALSE).
}
\description{
Returns TRUE when variant positions are present in a specified alignment in HLAalignments. Returns false when any variant position is not present in the specified alignment and generates a message identifying such positions.
}
\note{
For internal HLAtools use.
}
