% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rotate_ranefs.R
\name{rotate_ranef.default}
\alias{rotate_ranef}
\alias{rotate_ranef.default}
\alias{rotate_ranef.lme}
\alias{rotate_ranef.lmerMod}
\alias{rotate_ranef.mer}
\title{Calculate s-dimensional rotated random effects}
\usage{
\method{rotate_ranef}{default}(.mod, ...)

\method{rotate_ranef}{mer}(.mod, .L, s = NULL, .varimax = FALSE, ...)

\method{rotate_ranef}{lmerMod}(.mod, .L, s = NULL, .varimax = FALSE, ...)

\method{rotate_ranef}{lme}(.mod, .L, s = NULL, .varimax = FALSE, ...)
}
\arguments{
\item{.mod}{an object of class \code{mer} or \code{lmerMod}.}

\item{...}{do not use}

\item{.L}{a matrix defining which combination of random effects are of interest.}

\item{s}{the dimension of the subspace of interest.}

\item{.varimax}{if \code{.varimax = TRUE} than the raw varimax rotation
will be applied to the resulting rotation.}
}
\description{
This function calculates reduced dimensional rotated random effects.
The rotation reduces the influence of the residuals from other levels
of the model so that distributional assessment of the resulting
random effects is possible.
}
\author{
Adam Loy \email{loyad01@gmail.com}
}
\references{
Loy, A. & Hofmann, H. (in press). Are you Normal?
The Problem of Confounded Residual Structures in Hierarchical Linear Models.
\emph{Journal of Computational and Graphical Statistics}.
}
\examples{
library(lme4)
fm <- lmer(log.radon ~ basement + uranium + (basement | county), data = radon)

ngrps <- summary(fm)$ngrps
L.b0  <- kronecker(Diagonal(ngrps), c(1, 0))
L.b1  <- kronecker(Diagonal(ngrps), c(0, 1))

b0.rot <- rotate_ranef(.mod = fm, .L = L.b0, s = 65, .varimax = TRUE)
qqnorm(b0.rot)

b1.rot <- rotate_ranef(.mod = fm, .L = L.b1, s = 65, .varimax = TRUE)
qqnorm(b1.rot)
}

