% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segsmooth.R
\name{segsmooth}
\alias{segsmooth}
\title{Smoothing data using the moving average method for the homogenous segmentation.}
\usage{
segsmooth(var = "Deflection", range = 11, data = data)
}
\arguments{
\item{var}{A character of the name of a variable in a dataset,
such as a road pavement performance indicator.}

\item{range}{A number of the size of moving window. An odd number is required.}

\item{data}{A data frame of monitoring data.}
}
\description{
A center aligned moving window is used for the moving average method.
}
\examples{
# preprocessing
def <- preprocessing(var = "Deflection", location = "SLK", data = deflection)
# smoothing
def$smooth_def <- segsmooth(var = "Deflection", range = 11, data = def)
# plot
n <- 1:500
plot(def$SLK[n], def$Deflection[n], type = "l",
     col = "lightblue", xlab = "SLK", ylab = "Deflection")
lines(def$SLK[n], def$smooth_def[n])

}
