/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.PlotBox;
import ptolemy.plot.plotml.PlotBoxMLParser;
import ptolemy.plot.plotml.PlotMLParser;

public class PlotMLApplication
extends PlotApplication {
    public PlotMLApplication() throws Exception {
        this((String[])null);
    }

    public PlotMLApplication(String[] stringArray) throws Exception {
        this(new Plot(), stringArray);
    }

    public PlotMLApplication(PlotBox plotBox, String[] stringArray) throws Exception {
        super(plotBox, stringArray);
    }

    public static void main(String[] stringArray) {
        try {
            PlotMLApplication plotMLApplication = new PlotMLApplication(new Plot(), stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotMLApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.3, Build: $Id: PlotMLApplication.java,v 1.17 2003/04/29 01:21:22 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2003, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotMLApplication is a standalone plot  application.\n  File formats understood: PlotML and Ptplot ASCII.\n  Left mouse button: Zooming.\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected void _read(URL uRL, InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(9);
        byte[] byArray = new byte[8];
        bufferedInputStream.read(byArray);
        bufferedInputStream.reset();
        if (new String(byArray).startsWith("<?xm")) {
            PlotBoxMLParser plotBoxMLParser = this._newParser();
            try {
                plotBoxMLParser.parse(uRL, bufferedInputStream);
            }
            catch (Exception exception) {
                String string;
                if (exception instanceof XmlException) {
                    XmlException xmlException = (XmlException)exception;
                    string = "PlotMLApplication: failed to parse PlotML data:\nline: " + xmlException.getLine() + ", column: " + xmlException.getColumn() + "\nIn entity: " + xmlException.getSystemId() + "\n";
                } else {
                    string = "PlotMLApplication: failed to parse PlotML data:\n";
                }
                System.err.println(string + exception.toString());
                exception.printStackTrace();
            }
        } else {
            super._read(uRL, bufferedInputStream);
        }
    }

    protected PlotBoxMLParser _newParser() {
        if (this.plot instanceof Plot) {
            return new PlotMLParser((Plot)this.plot);
        }
        return new PlotBoxMLParser(this.plot);
    }
}

