% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madPlot.R
\name{madPlot}
\alias{madPlot}
\title{Mean Absolute Deviation Plot}
\usage{
madPlot(hvt.prediction, ...)
}
\arguments{
\item{hvt.prediction}{List. A list of hvt.prediction obtained from the predictHVT
function.}

\item{...}{The ellipsis is passed to it as additional argument. (Used internally)}
}
\value{
Mean Absolute Deviation Plot
\item{mad_plot}{ggplot plot. A plot with percentage anomalies on y axis and mean absolute deviation values on xaxis. }
}
\description{
Function to create Mean Absolute Deviation Plot
}
\details{
This function plots percentage anomalies vs mean absolute deviation for test data. The plot helps in
deciding an optimal MAD value for the use case.
}
\examples{
data(USArrests)
#Split in train and test

train <- USArrests[1:40,]
test <- USArrests[41:50,]

hvt.results <- list()
hvt.results <- HVT(train, n_cells = 15, depth = 1, quant.err = 0.2,
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE,
                   quant_method="kmeans",diagnose=TRUE)

predictions <- predictHVT(test,hvt.results, child.level=2,mad.threshold = 0.2)
print(predictions$scoredPredictedData)
madPlot(hvt.prediction=predictions)
}
\seealso{
\code{\link{predictHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
\keyword{internal}
